<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageDailyProductType StructType
 * @subpackage Structs
 */
class JP_PackageDailyProductType extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ProductType;
    /**
     * The Day
     * @var string
     */
    public $Day;
    /**
     * Constructor method for JP_PackageDailyProductType
     * @uses JP_PackageDailyProductType::setProductType()
     * @uses JP_PackageDailyProductType::setDay()
     * @param string[] $productType
     * @param string $day
     */
    public function __construct(array $productType = array(), $day = null)
    {
        $this
            ->setProductType($productType)
            ->setDay($day);
    }
    /**
     * Get ProductType value
     * @return string[]|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $productType
     * @return \StructType\JP_PackageDailyProductType
     */
    public function setProductType(array $productType = array())
    {
        $invalidValues = array();
        foreach ($productType as $jP_PackageDailyProductTypeProductTypeItem) {
            if (!\EnumType\JP_ProductType::valueIsValid($jP_PackageDailyProductTypeProductTypeItem)) {
                $invalidValues[] = var_export($jP_PackageDailyProductTypeProductTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Add item to ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\JP_PackageDailyProductType
     */
    public function addToProductType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType[] = $item;
        return $this;
    }
    /**
     * Get Day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param string $day
     * @return \StructType\JP_PackageDailyProductType
     */
    public function setDay($day = null)
    {
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageDailyProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
