<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelBookingInfo StructType
 * @subpackage Structs
 */
class JP_HotelBookingInfo extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingPrice
     */
    public $Price;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The PackageContracts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageContracts;
    /**
     * The HotelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelCode;
    /**
     * The Preferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelPreference
     */
    public $Preferences;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for JP_HotelBookingInfo
     * @uses JP_HotelBookingInfo::setPrice()
     * @uses JP_HotelBookingInfo::setStatus()
     * @uses JP_HotelBookingInfo::setPackageContracts()
     * @uses JP_HotelBookingInfo::setHotelCode()
     * @uses JP_HotelBookingInfo::setPreferences()
     * @uses JP_HotelBookingInfo::setStart()
     * @uses JP_HotelBookingInfo::setEnd()
     * @param \StructType\JP_BookingPrice $price
     * @param string $status
     * @param string $packageContracts
     * @param string $hotelCode
     * @param \ArrayType\ArrayOfJP_HotelPreference $preferences
     * @param string $start
     * @param string $end
     */
    public function __construct(\StructType\JP_BookingPrice $price = null, $status = null, $packageContracts = null, $hotelCode = null, \ArrayType\ArrayOfJP_HotelPreference $preferences = null, $start = null, $end = null)
    {
        $this
            ->setPrice($price)
            ->setStatus($status)
            ->setPackageContracts($packageContracts)
            ->setHotelCode($hotelCode)
            ->setPreferences($preferences)
            ->setStart($start)
            ->setEnd($end);
    }
    /**
     * Get Price value
     * @return \StructType\JP_BookingPrice|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_BookingPrice $price
     * @return \StructType\JP_HotelBookingInfo
     */
    public function setPrice(\StructType\JP_BookingPrice $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_HotelBookingInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PackageContracts value
     * @return string|null
     */
    public function getPackageContracts()
    {
        return $this->PackageContracts;
    }
    /**
     * Set PackageContracts value
     * @uses \EnumType\JP_PackageContracts::valueIsValid()
     * @uses \EnumType\JP_PackageContracts::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packageContracts
     * @return \StructType\JP_HotelBookingInfo
     */
    public function setPackageContracts($packageContracts = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_PackageContracts::valueIsValid($packageContracts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_PackageContracts', is_array($packageContracts) ? implode(', ', $packageContracts) : var_export($packageContracts, true), implode(', ', \EnumType\JP_PackageContracts::getValidValues())), __LINE__);
        }
        $this->PackageContracts = $packageContracts;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JP_HotelBookingInfo
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get Preferences value
     * @return \ArrayType\ArrayOfJP_HotelPreference|null
     */
    public function getPreferences()
    {
        return $this->Preferences;
    }
    /**
     * Set Preferences value
     * @param \ArrayType\ArrayOfJP_HotelPreference $preferences
     * @return \StructType\JP_HotelBookingInfo
     */
    public function setPreferences(\ArrayType\ArrayOfJP_HotelPreference $preferences = null)
    {
        $this->Preferences = $preferences;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_HotelBookingInfo
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_HotelBookingInfo
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
}
