<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageResult StructType
 * @subpackage Structs
 */
class JP_PackageResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The DestinationZone
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DestinationZone;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The PackageInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageInfo
     */
    public $PackageInfo;
    /**
     * The AFIPInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageInfoAFIPAmount
     */
    public $AFIPInformation;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The Stays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageStay
     */
    public $Stays;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The Recommended
     * @var bool
     */
    public $Recommended;
    /**
     * The BestDeal
     * @var bool
     */
    public $BestDeal;
    /**
     * The LastMinute
     * @var bool
     */
    public $LastMinute;
    /**
     * The OriginZone
     * @var int
     */
    public $OriginZone;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_PackageResult
     * @uses JP_PackageResult::setStart()
     * @uses JP_PackageResult::setEnd()
     * @uses JP_PackageResult::setDestinationZone()
     * @uses JP_PackageResult::setStatus()
     * @uses JP_PackageResult::setPackageInfo()
     * @uses JP_PackageResult::setAFIPInformation()
     * @uses JP_PackageResult::setPrices()
     * @uses JP_PackageResult::setStays()
     * @uses JP_PackageResult::setAdditionalElements()
     * @uses JP_PackageResult::setRecommended()
     * @uses JP_PackageResult::setBestDeal()
     * @uses JP_PackageResult::setLastMinute()
     * @uses JP_PackageResult::setOriginZone()
     * @uses JP_PackageResult::setCode()
     * @uses JP_PackageResult::setRatePlanCode()
     * @param string $start
     * @param string $end
     * @param int $destinationZone
     * @param string $status
     * @param \StructType\JP_PackageInfo $packageInfo
     * @param \ArrayType\ArrayOfJP_PackageInfoAFIPAmount $aFIPInformation
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \ArrayType\ArrayOfJP_PackageStay $stays
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @param bool $recommended
     * @param bool $bestDeal
     * @param bool $lastMinute
     * @param int $originZone
     * @param string $code
     * @param string $ratePlanCode
     */
    public function __construct($start = null, $end = null, $destinationZone = null, $status = null, \StructType\JP_PackageInfo $packageInfo = null, \ArrayType\ArrayOfJP_PackageInfoAFIPAmount $aFIPInformation = null, \ArrayType\ArrayOfJP_Price $prices = null, \ArrayType\ArrayOfJP_PackageStay $stays = null, \StructType\JP_PackageAdditionalElements $additionalElements = null, $recommended = null, $bestDeal = null, $lastMinute = null, $originZone = null, $code = null, $ratePlanCode = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setDestinationZone($destinationZone)
            ->setStatus($status)
            ->setPackageInfo($packageInfo)
            ->setAFIPInformation($aFIPInformation)
            ->setPrices($prices)
            ->setStays($stays)
            ->setAdditionalElements($additionalElements)
            ->setRecommended($recommended)
            ->setBestDeal($bestDeal)
            ->setLastMinute($lastMinute)
            ->setOriginZone($originZone)
            ->setCode($code)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PackageResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PackageResult
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_PackageResult
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !(is_int($destinationZone) || ctype_digit($destinationZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_PackageResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PackageInfo value
     * @return \StructType\JP_PackageInfo|null
     */
    public function getPackageInfo()
    {
        return $this->PackageInfo;
    }
    /**
     * Set PackageInfo value
     * @param \StructType\JP_PackageInfo $packageInfo
     * @return \StructType\JP_PackageResult
     */
    public function setPackageInfo(\StructType\JP_PackageInfo $packageInfo = null)
    {
        $this->PackageInfo = $packageInfo;
        return $this;
    }
    /**
     * Get AFIPInformation value
     * @return \ArrayType\ArrayOfJP_PackageInfoAFIPAmount|null
     */
    public function getAFIPInformation()
    {
        return $this->AFIPInformation;
    }
    /**
     * Set AFIPInformation value
     * @param \ArrayType\ArrayOfJP_PackageInfoAFIPAmount $aFIPInformation
     * @return \StructType\JP_PackageResult
     */
    public function setAFIPInformation(\ArrayType\ArrayOfJP_PackageInfoAFIPAmount $aFIPInformation = null)
    {
        $this->AFIPInformation = $aFIPInformation;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_PackageResult
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Stays value
     * @return \ArrayType\ArrayOfJP_PackageStay|null
     */
    public function getStays()
    {
        return $this->Stays;
    }
    /**
     * Set Stays value
     * @param \ArrayType\ArrayOfJP_PackageStay $stays
     * @return \StructType\JP_PackageResult
     */
    public function setStays(\ArrayType\ArrayOfJP_PackageStay $stays = null)
    {
        $this->Stays = $stays;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_PackageAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @return \StructType\JP_PackageResult
     */
    public function setAdditionalElements(\StructType\JP_PackageAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get Recommended value
     * @return bool|null
     */
    public function getRecommended()
    {
        return $this->Recommended;
    }
    /**
     * Set Recommended value
     * @param bool $recommended
     * @return \StructType\JP_PackageResult
     */
    public function setRecommended($recommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($recommended) && !is_bool($recommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recommended, true), gettype($recommended)), __LINE__);
        }
        $this->Recommended = $recommended;
        return $this;
    }
    /**
     * Get BestDeal value
     * @return bool|null
     */
    public function getBestDeal()
    {
        return $this->BestDeal;
    }
    /**
     * Set BestDeal value
     * @param bool $bestDeal
     * @return \StructType\JP_PackageResult
     */
    public function setBestDeal($bestDeal = null)
    {
        // validation for constraint: boolean
        if (!is_null($bestDeal) && !is_bool($bestDeal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bestDeal, true), gettype($bestDeal)), __LINE__);
        }
        $this->BestDeal = $bestDeal;
        return $this;
    }
    /**
     * Get LastMinute value
     * @return bool|null
     */
    public function getLastMinute()
    {
        return $this->LastMinute;
    }
    /**
     * Set LastMinute value
     * @param bool $lastMinute
     * @return \StructType\JP_PackageResult
     */
    public function setLastMinute($lastMinute = null)
    {
        // validation for constraint: boolean
        if (!is_null($lastMinute) && !is_bool($lastMinute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lastMinute, true), gettype($lastMinute)), __LINE__);
        }
        $this->LastMinute = $lastMinute;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return int|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_PackageResult
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !(is_int($originZone) || ctype_digit($originZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_PackageResult
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
}
