<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_StayRestrictions StructType
 * @subpackage Structs
 */
class JPSOAP_StayRestrictions extends AbstractStructBase
{
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Application;
    /**
     * The LengthOfStay
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_LengthOfStay[]
     */
    public $LengthOfStay;
    /**
     * The MinNights
     * @var int
     */
    public $MinNights;
    /**
     * The MaxNights
     * @var int
     */
    public $MaxNights;
    /**
     * The ApplyToLengthStayOnly
     * @var bool
     */
    public $ApplyToLengthStayOnly;
    /**
     * Constructor method for JPSOAP_StayRestrictions
     * @uses JPSOAP_StayRestrictions::setApplication()
     * @uses JPSOAP_StayRestrictions::setLengthOfStay()
     * @uses JPSOAP_StayRestrictions::setMinNights()
     * @uses JPSOAP_StayRestrictions::setMaxNights()
     * @uses JPSOAP_StayRestrictions::setApplyToLengthStayOnly()
     * @param string $application
     * @param \StructType\JPSOAP_LengthOfStay[] $lengthOfStay
     * @param int $minNights
     * @param int $maxNights
     * @param bool $applyToLengthStayOnly
     */
    public function __construct($application = null, array $lengthOfStay = array(), $minNights = null, $maxNights = null, $applyToLengthStayOnly = null)
    {
        $this
            ->setApplication($application)
            ->setLengthOfStay($lengthOfStay)
            ->setMinNights($minNights)
            ->setMaxNights($maxNights)
            ->setApplyToLengthStayOnly($applyToLengthStayOnly);
    }
    /**
     * Get Application value
     * @return string
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @uses \EnumType\JPSOAP_StayRestrictionsApplication::valueIsValid()
     * @uses \EnumType\JPSOAP_StayRestrictionsApplication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $application
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setApplication($application = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_StayRestrictionsApplication::valueIsValid($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_StayRestrictionsApplication', is_array($application) ? implode(', ', $application) : var_export($application, true), implode(', ', \EnumType\JPSOAP_StayRestrictionsApplication::getValidValues())), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get LengthOfStay value
     * @return \StructType\JPSOAP_LengthOfStay[]|null
     */
    public function getLengthOfStay()
    {
        return $this->LengthOfStay;
    }
    /**
     * This method is responsible for validating the values passed to the setLengthOfStay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLengthOfStay method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLengthOfStayForArrayConstraintsFromSetLengthOfStay(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jPSOAP_StayRestrictionsLengthOfStayItem) {
            // validation for constraint: itemType
            if (!$jPSOAP_StayRestrictionsLengthOfStayItem instanceof \StructType\JPSOAP_LengthOfStay) {
                $invalidValues[] = is_object($jPSOAP_StayRestrictionsLengthOfStayItem) ? get_class($jPSOAP_StayRestrictionsLengthOfStayItem) : sprintf('%s(%s)', gettype($jPSOAP_StayRestrictionsLengthOfStayItem), var_export($jPSOAP_StayRestrictionsLengthOfStayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LengthOfStay property can only contain items of type \StructType\JPSOAP_LengthOfStay, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LengthOfStay value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_LengthOfStay[] $lengthOfStay
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setLengthOfStay(array $lengthOfStay = array())
    {
        // validation for constraint: array
        if ('' !== ($lengthOfStayArrayErrorMessage = self::validateLengthOfStayForArrayConstraintsFromSetLengthOfStay($lengthOfStay))) {
            throw new \InvalidArgumentException($lengthOfStayArrayErrorMessage, __LINE__);
        }
        $this->LengthOfStay = $lengthOfStay;
        return $this;
    }
    /**
     * Add item to LengthOfStay value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_LengthOfStay $item
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function addToLengthOfStay(\StructType\JPSOAP_LengthOfStay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_LengthOfStay) {
            throw new \InvalidArgumentException(sprintf('The LengthOfStay property can only contain items of type \StructType\JPSOAP_LengthOfStay, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LengthOfStay[] = $item;
        return $this;
    }
    /**
     * Get MinNights value
     * @return int|null
     */
    public function getMinNights()
    {
        return $this->MinNights;
    }
    /**
     * Set MinNights value
     * @param int $minNights
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setMinNights($minNights = null)
    {
        // validation for constraint: int
        if (!is_null($minNights) && !(is_int($minNights) || ctype_digit($minNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minNights, true), gettype($minNights)), __LINE__);
        }
        $this->MinNights = $minNights;
        return $this;
    }
    /**
     * Get MaxNights value
     * @return int|null
     */
    public function getMaxNights()
    {
        return $this->MaxNights;
    }
    /**
     * Set MaxNights value
     * @param int $maxNights
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setMaxNights($maxNights = null)
    {
        // validation for constraint: int
        if (!is_null($maxNights) && !(is_int($maxNights) || ctype_digit($maxNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNights, true), gettype($maxNights)), __LINE__);
        }
        $this->MaxNights = $maxNights;
        return $this;
    }
    /**
     * Get ApplyToLengthStayOnly value
     * @return bool|null
     */
    public function getApplyToLengthStayOnly()
    {
        return $this->ApplyToLengthStayOnly;
    }
    /**
     * Set ApplyToLengthStayOnly value
     * @param bool $applyToLengthStayOnly
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setApplyToLengthStayOnly($applyToLengthStayOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyToLengthStayOnly) && !is_bool($applyToLengthStayOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyToLengthStayOnly, true), gettype($applyToLengthStayOnly)), __LINE__);
        }
        $this->ApplyToLengthStayOnly = $applyToLengthStayOnly;
        return $this;
    }
}
