<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_InsuranceBookingRules StructType
 * @subpackage Structs
 */
class JP_InsuranceBookingRules extends AbstractStructBase
{
    /**
     * The BookingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The InsuranceRequiredFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceRequiredFields
     */
    public $InsuranceRequiredFields;
    /**
     * The CancellationPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The PriceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsurancePriceInformation
     */
    public $PriceInformation;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_InsuranceBookingRules
     * @uses JP_InsuranceBookingRules::setBookingCode()
     * @uses JP_InsuranceBookingRules::setInsuranceRequiredFields()
     * @uses JP_InsuranceBookingRules::setCancellationPolicy()
     * @uses JP_InsuranceBookingRules::setCancellationPolicyCost()
     * @uses JP_InsuranceBookingRules::setPriceInformation()
     * @uses JP_InsuranceBookingRules::setRatePlanCode()
     * @uses JP_InsuranceBookingRules::setStatus()
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_InsuranceRequiredFields $insuranceRequiredFields
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \StructType\JP_InsurancePriceInformation $priceInformation
     * @param string $ratePlanCode
     * @param string $status
     */
    public function __construct(\StructType\JP_BookingCode $bookingCode = null, \StructType\JP_InsuranceRequiredFields $insuranceRequiredFields = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \StructType\JP_InsurancePriceInformation $priceInformation = null, $ratePlanCode = null, $status = null)
    {
        $this
            ->setBookingCode($bookingCode)
            ->setInsuranceRequiredFields($insuranceRequiredFields)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setPriceInformation($priceInformation)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status);
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_InsuranceBookingRules
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get InsuranceRequiredFields value
     * @return \StructType\JP_InsuranceRequiredFields|null
     */
    public function getInsuranceRequiredFields()
    {
        return $this->InsuranceRequiredFields;
    }
    /**
     * Set InsuranceRequiredFields value
     * @param \StructType\JP_InsuranceRequiredFields $insuranceRequiredFields
     * @return \StructType\JP_InsuranceBookingRules
     */
    public function setInsuranceRequiredFields(\StructType\JP_InsuranceRequiredFields $insuranceRequiredFields = null)
    {
        $this->InsuranceRequiredFields = $insuranceRequiredFields;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_InsuranceBookingRules
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_InsuranceBookingRules
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_InsurancePriceInformation|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_InsurancePriceInformation $priceInformation
     * @return \StructType\JP_InsuranceBookingRules
     */
    public function setPriceInformation(\StructType\JP_InsurancePriceInformation $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_InsuranceBookingRules
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_InsuranceBookingRules
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_InsuranceBookingRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
