<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FlightSupplement StructType
 * @subpackage Structs
 */
class JP_FlightSupplement extends AbstractStructBase
{
    /**
     * The Units
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Units;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The RelPaxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ExtendedRelPax
     */
    public $RelPaxes;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Price
     */
    public $Price;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_FlightSupplement
     * @uses JP_FlightSupplement::setUnits()
     * @uses JP_FlightSupplement::setName()
     * @uses JP_FlightSupplement::setRelPaxes()
     * @uses JP_FlightSupplement::setPrice()
     * @uses JP_FlightSupplement::setRatePlanCode()
     * @param int $units
     * @param string $name
     * @param \ArrayType\ArrayOfJP_ExtendedRelPax $relPaxes
     * @param \StructType\JP_Price $price
     * @param string $ratePlanCode
     */
    public function __construct($units = null, $name = null, \ArrayType\ArrayOfJP_ExtendedRelPax $relPaxes = null, \StructType\JP_Price $price = null, $ratePlanCode = null)
    {
        $this
            ->setUnits($units)
            ->setName($name)
            ->setRelPaxes($relPaxes)
            ->setPrice($price)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Units value
     * @return int
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @param int $units
     * @return \StructType\JP_FlightSupplement
     */
    public function setUnits($units = null)
    {
        // validation for constraint: int
        if (!is_null($units) && !is_numeric($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($units)), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_FlightSupplement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_ExtendedRelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_ExtendedRelPax $relPaxes
     * @return \StructType\JP_FlightSupplement
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_ExtendedRelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\JP_Price|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_Price $price
     * @return \StructType\JP_FlightSupplement
     */
    public function setPrice(\StructType\JP_Price $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_FlightSupplement
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FlightSupplement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
