<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_DailyHotelContract StructType
 * @subpackage Structs
 */
class JP_DailyHotelContract extends JP_Contract
{
    /**
     * The StayDate
     * @var string
     */
    public $StayDate;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_DailyHotelContract
     * @uses JP_DailyHotelContract::setStayDate()
     * @uses JP_DailyHotelContract::setCode()
     * @param string $stayDate
     * @param string $code
     */
    public function __construct($stayDate = null, $code = null)
    {
        $this
            ->setStayDate($stayDate)
            ->setCode($code);
    }
    /**
     * Get StayDate value
     * @return string|null
     */
    public function getStayDate()
    {
        return $this->StayDate;
    }
    /**
     * Set StayDate value
     * @param string $stayDate
     * @return \StructType\JP_DailyHotelContract
     */
    public function setStayDate($stayDate = null)
    {
        // validation for constraint: string
        if (!is_null($stayDate) && !is_string($stayDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stayDate)), __LINE__);
        }
        $this->StayDate = $stayDate;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_DailyHotelContract
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_DailyHotelContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
