<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_IdTypeIntName StructType
 * @subpackage Structs
 */
class JPSOAP_IdTypeIntName extends JPSOAP_IdName
{
    /**
     * The TypeCode
     * @var int
     */
    public $TypeCode;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for JPSOAP_IdTypeIntName
     * @uses JPSOAP_IdTypeIntName::setTypeCode()
     * @uses JPSOAP_IdTypeIntName::setType()
     * @param int $typeCode
     * @param string $type
     */
    public function __construct($typeCode = null, $type = null)
    {
        $this
            ->setTypeCode($typeCode)
            ->setType($type);
    }
    /**
     * Get TypeCode value
     * @return int|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param int $typeCode
     * @return \StructType\JPSOAP_IdTypeIntName
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: int
        if (!is_null($typeCode) && !is_numeric($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JPSOAP_IdTypeIntName
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_IdTypeIntName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
