<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelInventoryRoomType StructType
 * @subpackage Structs
 */
class JPSOAP_HotelInventoryRoomType extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Code;
    /**
     * The PricePerRoom
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $PricePerRoom;
    /**
     * The NonRefundable
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $NonRefundable;
    /**
     * The childAsAdult
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $childAsAdult;
    /**
     * The Occupancies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_Occupancy
     */
    public $Occupancies;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_IdTypeName
     */
    public $Category;
    /**
     * The MinAge
     * @var int
     */
    public $MinAge;
    /**
     * The MaxPax
     * @var int
     */
    public $MaxPax;
    /**
     * The AdultAdditionalFrom
     * @var int
     */
    public $AdultAdditionalFrom;
    /**
     * The AlternativeAllotmentRoomType
     * @var int
     */
    public $AlternativeAllotmentRoomType;
    /**
     * The ExternalCode
     * @var string
     */
    public $ExternalCode;
    /**
     * Constructor method for JPSOAP_HotelInventoryRoomType
     * @uses JPSOAP_HotelInventoryRoomType::setCode()
     * @uses JPSOAP_HotelInventoryRoomType::setPricePerRoom()
     * @uses JPSOAP_HotelInventoryRoomType::setNonRefundable()
     * @uses JPSOAP_HotelInventoryRoomType::setChildAsAdult()
     * @uses JPSOAP_HotelInventoryRoomType::setOccupancies()
     * @uses JPSOAP_HotelInventoryRoomType::setName()
     * @uses JPSOAP_HotelInventoryRoomType::setCategory()
     * @uses JPSOAP_HotelInventoryRoomType::setMinAge()
     * @uses JPSOAP_HotelInventoryRoomType::setMaxPax()
     * @uses JPSOAP_HotelInventoryRoomType::setAdultAdditionalFrom()
     * @uses JPSOAP_HotelInventoryRoomType::setAlternativeAllotmentRoomType()
     * @uses JPSOAP_HotelInventoryRoomType::setExternalCode()
     * @param int $code
     * @param bool $pricePerRoom
     * @param bool $nonRefundable
     * @param bool $childAsAdult
     * @param \ArrayType\ArrayOfJPSOAP_Occupancy $occupancies
     * @param string $name
     * @param \StructType\JPSOAP_IdTypeName $category
     * @param int $minAge
     * @param int $maxPax
     * @param int $adultAdditionalFrom
     * @param int $alternativeAllotmentRoomType
     * @param string $externalCode
     */
    public function __construct($code = null, $pricePerRoom = null, $nonRefundable = null, $childAsAdult = null, \ArrayType\ArrayOfJPSOAP_Occupancy $occupancies = null, $name = null, \StructType\JPSOAP_IdTypeName $category = null, $minAge = null, $maxPax = null, $adultAdditionalFrom = null, $alternativeAllotmentRoomType = null, $externalCode = null)
    {
        $this
            ->setCode($code)
            ->setPricePerRoom($pricePerRoom)
            ->setNonRefundable($nonRefundable)
            ->setChildAsAdult($childAsAdult)
            ->setOccupancies($occupancies)
            ->setName($name)
            ->setCategory($category)
            ->setMinAge($minAge)
            ->setMaxPax($maxPax)
            ->setAdultAdditionalFrom($adultAdditionalFrom)
            ->setAlternativeAllotmentRoomType($alternativeAllotmentRoomType)
            ->setExternalCode($externalCode);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get PricePerRoom value
     * @return bool
     */
    public function getPricePerRoom()
    {
        return $this->PricePerRoom;
    }
    /**
     * Set PricePerRoom value
     * @param bool $pricePerRoom
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setPricePerRoom($pricePerRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($pricePerRoom) && !is_bool($pricePerRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pricePerRoom)), __LINE__);
        }
        $this->PricePerRoom = $pricePerRoom;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get childAsAdult value
     * @return bool
     */
    public function getChildAsAdult()
    {
        return $this->childAsAdult;
    }
    /**
     * Set childAsAdult value
     * @param bool $childAsAdult
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setChildAsAdult($childAsAdult = null)
    {
        // validation for constraint: boolean
        if (!is_null($childAsAdult) && !is_bool($childAsAdult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($childAsAdult)), __LINE__);
        }
        $this->childAsAdult = $childAsAdult;
        return $this;
    }
    /**
     * Get Occupancies value
     * @return \ArrayType\ArrayOfJPSOAP_Occupancy|null
     */
    public function getOccupancies()
    {
        return $this->Occupancies;
    }
    /**
     * Set Occupancies value
     * @param \ArrayType\ArrayOfJPSOAP_Occupancy $occupancies
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setOccupancies(\ArrayType\ArrayOfJPSOAP_Occupancy $occupancies = null)
    {
        $this->Occupancies = $occupancies;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Category value
     * @return \StructType\JPSOAP_IdTypeName|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\JPSOAP_IdTypeName $category
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setCategory(\StructType\JPSOAP_IdTypeName $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !is_numeric($minAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxPax value
     * @return int|null
     */
    public function getMaxPax()
    {
        return $this->MaxPax;
    }
    /**
     * Set MaxPax value
     * @param int $maxPax
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setMaxPax($maxPax = null)
    {
        // validation for constraint: int
        if (!is_null($maxPax) && !is_numeric($maxPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxPax)), __LINE__);
        }
        $this->MaxPax = $maxPax;
        return $this;
    }
    /**
     * Get AdultAdditionalFrom value
     * @return int|null
     */
    public function getAdultAdditionalFrom()
    {
        return $this->AdultAdditionalFrom;
    }
    /**
     * Set AdultAdditionalFrom value
     * @param int $adultAdditionalFrom
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setAdultAdditionalFrom($adultAdditionalFrom = null)
    {
        // validation for constraint: int
        if (!is_null($adultAdditionalFrom) && !is_numeric($adultAdditionalFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adultAdditionalFrom)), __LINE__);
        }
        $this->AdultAdditionalFrom = $adultAdditionalFrom;
        return $this;
    }
    /**
     * Get AlternativeAllotmentRoomType value
     * @return int|null
     */
    public function getAlternativeAllotmentRoomType()
    {
        return $this->AlternativeAllotmentRoomType;
    }
    /**
     * Set AlternativeAllotmentRoomType value
     * @param int $alternativeAllotmentRoomType
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setAlternativeAllotmentRoomType($alternativeAllotmentRoomType = null)
    {
        // validation for constraint: int
        if (!is_null($alternativeAllotmentRoomType) && !is_numeric($alternativeAllotmentRoomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($alternativeAllotmentRoomType)), __LINE__);
        }
        $this->AlternativeAllotmentRoomType = $alternativeAllotmentRoomType;
        return $this;
    }
    /**
     * Get ExternalCode value
     * @return string|null
     */
    public function getExternalCode()
    {
        return $this->ExternalCode;
    }
    /**
     * Set ExternalCode value
     * @param string $externalCode
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public function setExternalCode($externalCode = null)
    {
        // validation for constraint: string
        if (!is_null($externalCode) && !is_string($externalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalCode)), __LINE__);
        }
        $this->ExternalCode = $externalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_HotelInventoryRoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
