<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ModifyAdvancedOptions StructType
 * @subpackage Structs
 */
class JP_ModifyAdvancedOptions extends JP_BaseAdvancedOptions
{
    /**
     * The UseCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UseCurrency;
    /**
     * The SendMailTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendMailTo;
    /**
     * The ShowBreakdownPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowBreakdownPrice;
    /**
     * Constructor method for JP_ModifyAdvancedOptions
     * @uses JP_ModifyAdvancedOptions::setUseCurrency()
     * @uses JP_ModifyAdvancedOptions::setSendMailTo()
     * @uses JP_ModifyAdvancedOptions::setShowBreakdownPrice()
     * @param string $useCurrency
     * @param string $sendMailTo
     * @param bool $showBreakdownPrice
     */
    public function __construct($useCurrency = null, $sendMailTo = null, $showBreakdownPrice = null)
    {
        $this
            ->setUseCurrency($useCurrency)
            ->setSendMailTo($sendMailTo)
            ->setShowBreakdownPrice($showBreakdownPrice);
    }
    /**
     * Get UseCurrency value
     * @return string|null
     */
    public function getUseCurrency()
    {
        return $this->UseCurrency;
    }
    /**
     * Set UseCurrency value
     * @param string $useCurrency
     * @return \StructType\JP_ModifyAdvancedOptions
     */
    public function setUseCurrency($useCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($useCurrency) && !is_string($useCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCurrency)), __LINE__);
        }
        $this->UseCurrency = $useCurrency;
        return $this;
    }
    /**
     * Get SendMailTo value
     * @return string|null
     */
    public function getSendMailTo()
    {
        return $this->SendMailTo;
    }
    /**
     * Set SendMailTo value
     * @uses \EnumType\JP_SendMailTo::valueIsValid()
     * @uses \EnumType\JP_SendMailTo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendMailTo
     * @return \StructType\JP_ModifyAdvancedOptions
     */
    public function setSendMailTo($sendMailTo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_SendMailTo::valueIsValid($sendMailTo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sendMailTo, implode(', ', \EnumType\JP_SendMailTo::getValidValues())), __LINE__);
        }
        $this->SendMailTo = $sendMailTo;
        return $this;
    }
    /**
     * Get ShowBreakdownPrice value
     * @return bool|null
     */
    public function getShowBreakdownPrice()
    {
        return $this->ShowBreakdownPrice;
    }
    /**
     * Set ShowBreakdownPrice value
     * @param bool $showBreakdownPrice
     * @return \StructType\JP_ModifyAdvancedOptions
     */
    public function setShowBreakdownPrice($showBreakdownPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($showBreakdownPrice) && !is_bool($showBreakdownPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($showBreakdownPrice)), __LINE__);
        }
        $this->ShowBreakdownPrice = $showBreakdownPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ModifyAdvancedOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
