<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseCheckAvail StructType
 * @subpackage Structs
 */
class JP_CruiseCheckAvail extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The Paxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The CruiseCheckAvailRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseCheckAvailRequest
     */
    public $CruiseCheckAvailRequest;
    /**
     * The AdvancedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseCheckAvailAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for JP_CruiseCheckAvail
     * @uses JP_CruiseCheckAvail::setLogin()
     * @uses JP_CruiseCheckAvail::setPaxes()
     * @uses JP_CruiseCheckAvail::setCruiseCheckAvailRequest()
     * @uses JP_CruiseCheckAvail::setAdvancedOptions()
     * @uses JP_CruiseCheckAvail::setRestrictedOptions()
     * @uses JP_CruiseCheckAvail::setVersion()
     * @uses JP_CruiseCheckAvail::setLanguage()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_Paxes $paxes
     * @param \StructType\JP_CruiseCheckAvailRequest $cruiseCheckAvailRequest
     * @param \StructType\JP_CruiseCheckAvailAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_Paxes $paxes = null, \StructType\JP_CruiseCheckAvailRequest $cruiseCheckAvailRequest = null, \StructType\JP_CruiseCheckAvailAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null)
    {
        $this
            ->setLogin($login)
            ->setPaxes($paxes)
            ->setCruiseCheckAvailRequest($cruiseCheckAvailRequest)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_CruiseCheckAvail
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_CruiseCheckAvail
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get CruiseCheckAvailRequest value
     * @return \StructType\JP_CruiseCheckAvailRequest|null
     */
    public function getCruiseCheckAvailRequest()
    {
        return $this->CruiseCheckAvailRequest;
    }
    /**
     * Set CruiseCheckAvailRequest value
     * @param \StructType\JP_CruiseCheckAvailRequest $cruiseCheckAvailRequest
     * @return \StructType\JP_CruiseCheckAvail
     */
    public function setCruiseCheckAvailRequest(\StructType\JP_CruiseCheckAvailRequest $cruiseCheckAvailRequest = null)
    {
        $this->CruiseCheckAvailRequest = $cruiseCheckAvailRequest;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_CruiseCheckAvailAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_CruiseCheckAvailAdvancedOptions $advancedOptions
     * @return \StructType\JP_CruiseCheckAvail
     */
    public function setAdvancedOptions(\StructType\JP_CruiseCheckAvailAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_CruiseCheckAvail
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_CruiseCheckAvail
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_CruiseCheckAvail
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseCheckAvail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
