<?php

namespace EnumType;

/**
 * This class stands for StationsType EnumType
 * @subpackage Enumerations
 */
class StationsType
{
    /**
     * Constant for value 'AEO'
     * @return string 'AEO'
     */
    const VALUE_AEO = 'AEO';
    /**
     * Constant for value 'CITY'
     * @return string 'CITY'
     */
    const VALUE_CITY = 'CITY';
    /**
     * Constant for value 'BUS'
     * @return string 'BUS'
     */
    const VALUE_BUS = 'BUS';
    /**
     * Constant for value 'TRN'
     * @return string 'TRN'
     */
    const VALUE_TRN = 'TRN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AEO
     * @uses self::VALUE_CITY
     * @uses self::VALUE_BUS
     * @uses self::VALUE_TRN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AEO,
            self::VALUE_CITY,
            self::VALUE_BUS,
            self::VALUE_TRN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
