<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString5 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString5 extends AbstractStructArrayBase
{
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Supplier;
    /**
     * Constructor method for ArrayOfString5
     * @uses ArrayOfString5::setSupplier()
     * @param string[] $supplier
     */
    public function __construct(array $supplier = array())
    {
        $this
            ->setSupplier($supplier);
    }
    /**
     * Get Supplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSupplier()
    {
        return isset($this->Supplier) ? $this->Supplier : null;
    }
    /**
     * Set Supplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $supplier
     * @return \ArrayType\ArrayOfString5
     */
    public function setSupplier(array $supplier = array())
    {
        foreach ($supplier as $arrayOfString5SupplierItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString5SupplierItem)) {
                throw new \InvalidArgumentException(sprintf('The Supplier property can only contain items of string, "%s" given', is_object($arrayOfString5SupplierItem) ? get_class($arrayOfString5SupplierItem) : gettype($arrayOfString5SupplierItem)), __LINE__);
            }
        }
        if (is_null($supplier) || (is_array($supplier) && empty($supplier))) {
            unset($this->Supplier);
        } else {
            $this->Supplier = $supplier;
        }
        return $this;
    }
    /**
     * Add item to Supplier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString5
     */
    public function addToSupplier($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Supplier property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Supplier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Supplier
     */
    public function getAttributeName()
    {
        return 'Supplier';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
