<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageCalendarPriceParameter StructType
 * @subpackage Structs
 */
class JP_PackageCalendarPriceParameter extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The PackageCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackagesCodeList
     */
    public $PackageCodes;
    /**
     * The OriginZone
     * @var int
     */
    public $OriginZone;
    /**
     * The DestinationZone
     * @var int
     */
    public $DestinationZone;
    /**
     * Constructor method for JP_PackageCalendarPriceParameter
     * @uses JP_PackageCalendarPriceParameter::setStart()
     * @uses JP_PackageCalendarPriceParameter::setEnd()
     * @uses JP_PackageCalendarPriceParameter::setPackageCodes()
     * @uses JP_PackageCalendarPriceParameter::setOriginZone()
     * @uses JP_PackageCalendarPriceParameter::setDestinationZone()
     * @param string $start
     * @param string $end
     * @param \ArrayType\ArrayOfJP_PackagesCodeList $packageCodes
     * @param int $originZone
     * @param int $destinationZone
     */
    public function __construct($start = null, $end = null, \ArrayType\ArrayOfJP_PackagesCodeList $packageCodes = null, $originZone = null, $destinationZone = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setPackageCodes($packageCodes)
            ->setOriginZone($originZone)
            ->setDestinationZone($destinationZone);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PackageCalendarPriceParameter
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PackageCalendarPriceParameter
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get PackageCodes value
     * @return \ArrayType\ArrayOfJP_PackagesCodeList|null
     */
    public function getPackageCodes()
    {
        return $this->PackageCodes;
    }
    /**
     * Set PackageCodes value
     * @param \ArrayType\ArrayOfJP_PackagesCodeList $packageCodes
     * @return \StructType\JP_PackageCalendarPriceParameter
     */
    public function setPackageCodes(\ArrayType\ArrayOfJP_PackagesCodeList $packageCodes = null)
    {
        $this->PackageCodes = $packageCodes;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return int|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_PackageCalendarPriceParameter
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !(is_int($originZone) || ctype_digit($originZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_PackageCalendarPriceParameter
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !(is_int($destinationZone) || ctype_digit($destinationZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
}
