<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseBookingInfo StructType
 * @subpackage Structs
 */
class JP_CruiseBookingInfo extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingPrice
     */
    public $Price;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_CruiseBookingInfo
     * @uses JP_CruiseBookingInfo::setPrice()
     * @uses JP_CruiseBookingInfo::setStatus()
     * @param \StructType\JP_BookingPrice $price
     * @param string $status
     */
    public function __construct(\StructType\JP_BookingPrice $price = null, $status = null)
    {
        $this
            ->setPrice($price)
            ->setStatus($status);
    }
    /**
     * Get Price value
     * @return \StructType\JP_BookingPrice|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_BookingPrice $price
     * @return \StructType\JP_CruiseBookingInfo
     */
    public function setPrice(\StructType\JP_BookingPrice $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_CruiseBookingInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
