<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceContentInfo StructType
 * @subpackage Structs
 */
class JP_ServiceContentInfo extends AbstractStructBase
{
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceName;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Description
     */
    public $Descriptions;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $Images;
    /**
     * Constructor method for JP_ServiceContentInfo
     * @uses JP_ServiceContentInfo::setServiceName()
     * @uses JP_ServiceContentInfo::setDescriptions()
     * @uses JP_ServiceContentInfo::setImages()
     * @param string $serviceName
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     */
    public function __construct($serviceName = null, \ArrayType\ArrayOfJP_Description $descriptions = null, \ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setDescriptions($descriptions)
            ->setImages($images);
    }
    /**
     * Get ServiceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
    /**
     * Set ServiceName value
     * @param string $serviceName
     * @return \StructType\JP_ServiceContentInfo
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        $this->ServiceName = $serviceName;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \ArrayType\ArrayOfJP_Description|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @return \StructType\JP_ServiceContentInfo
     */
    public function setDescriptions(\ArrayType\ArrayOfJP_Description $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @return \StructType\JP_ServiceContentInfo
     */
    public function setImages(\ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this->Images = $images;
        return $this;
    }
}
