<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelAvailAdvancedOptions StructType
 * @subpackage Structs
 */
class JP_HotelAvailAdvancedOptions extends JP_AvailAdvancedOptions
{
    /**
     * The ShowHotelInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowHotelInfo;
    /**
     * The ShowOnlyAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowOnlyAvailable;
    /**
     * The ShowAllCombinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowAllCombinations;
    /**
     * The MaxCombinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MaxCombinations;
    /**
     * The ShowOnlyBestPriceCombination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowOnlyBestPriceCombination;
    /**
     * The ShowAllRates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowAllRates;
    /**
     * The ShowAllPortfolio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowAllPortfolio;
    /**
     * The ShowAllChildrenCombinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowAllChildrenCombinations;
    /**
     * The ShowCancellationPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowCancellationPolicies;
    /**
     * The ExcludeNonRefundable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludeNonRefundable;
    /**
     * The ShowDynamicInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowDynamicInventory;
    /**
     * The ShowCompleteInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowCompleteInfo;
    /**
     * The HideRatePlanCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $HideRatePlanCode;
    /**
     * The TimeOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TimeOut;
    /**
     * The ShowAvailabilityBreakdown
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowAvailabilityBreakdown;
    /**
     * The MinimumPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MinimumPrice;
    /**
     * Constructor method for JP_HotelAvailAdvancedOptions
     * @uses JP_HotelAvailAdvancedOptions::setShowHotelInfo()
     * @uses JP_HotelAvailAdvancedOptions::setShowOnlyAvailable()
     * @uses JP_HotelAvailAdvancedOptions::setShowAllCombinations()
     * @uses JP_HotelAvailAdvancedOptions::setMaxCombinations()
     * @uses JP_HotelAvailAdvancedOptions::setShowOnlyBestPriceCombination()
     * @uses JP_HotelAvailAdvancedOptions::setShowAllRates()
     * @uses JP_HotelAvailAdvancedOptions::setShowAllPortfolio()
     * @uses JP_HotelAvailAdvancedOptions::setShowAllChildrenCombinations()
     * @uses JP_HotelAvailAdvancedOptions::setShowCancellationPolicies()
     * @uses JP_HotelAvailAdvancedOptions::setExcludeNonRefundable()
     * @uses JP_HotelAvailAdvancedOptions::setShowDynamicInventory()
     * @uses JP_HotelAvailAdvancedOptions::setShowCompleteInfo()
     * @uses JP_HotelAvailAdvancedOptions::setHideRatePlanCode()
     * @uses JP_HotelAvailAdvancedOptions::setTimeOut()
     * @uses JP_HotelAvailAdvancedOptions::setShowAvailabilityBreakdown()
     * @uses JP_HotelAvailAdvancedOptions::setMinimumPrice()
     * @param bool $showHotelInfo
     * @param bool $showOnlyAvailable
     * @param bool $showAllCombinations
     * @param int $maxCombinations
     * @param bool $showOnlyBestPriceCombination
     * @param bool $showAllRates
     * @param bool $showAllPortfolio
     * @param bool $showAllChildrenCombinations
     * @param bool $showCancellationPolicies
     * @param bool $excludeNonRefundable
     * @param bool $showDynamicInventory
     * @param bool $showCompleteInfo
     * @param bool $hideRatePlanCode
     * @param int $timeOut
     * @param bool $showAvailabilityBreakdown
     * @param float $minimumPrice
     */
    public function __construct($showHotelInfo = null, $showOnlyAvailable = null, $showAllCombinations = null, $maxCombinations = null, $showOnlyBestPriceCombination = null, $showAllRates = null, $showAllPortfolio = null, $showAllChildrenCombinations = null, $showCancellationPolicies = null, $excludeNonRefundable = null, $showDynamicInventory = null, $showCompleteInfo = null, $hideRatePlanCode = null, $timeOut = null, $showAvailabilityBreakdown = null, $minimumPrice = null)
    {
        $this
            ->setShowHotelInfo($showHotelInfo)
            ->setShowOnlyAvailable($showOnlyAvailable)
            ->setShowAllCombinations($showAllCombinations)
            ->setMaxCombinations($maxCombinations)
            ->setShowOnlyBestPriceCombination($showOnlyBestPriceCombination)
            ->setShowAllRates($showAllRates)
            ->setShowAllPortfolio($showAllPortfolio)
            ->setShowAllChildrenCombinations($showAllChildrenCombinations)
            ->setShowCancellationPolicies($showCancellationPolicies)
            ->setExcludeNonRefundable($excludeNonRefundable)
            ->setShowDynamicInventory($showDynamicInventory)
            ->setShowCompleteInfo($showCompleteInfo)
            ->setHideRatePlanCode($hideRatePlanCode)
            ->setTimeOut($timeOut)
            ->setShowAvailabilityBreakdown($showAvailabilityBreakdown)
            ->setMinimumPrice($minimumPrice);
    }
    /**
     * Get ShowHotelInfo value
     * @return bool|null
     */
    public function getShowHotelInfo()
    {
        return $this->ShowHotelInfo;
    }
    /**
     * Set ShowHotelInfo value
     * @param bool $showHotelInfo
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowHotelInfo($showHotelInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($showHotelInfo) && !is_bool($showHotelInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showHotelInfo, true), gettype($showHotelInfo)), __LINE__);
        }
        $this->ShowHotelInfo = $showHotelInfo;
        return $this;
    }
    /**
     * Get ShowOnlyAvailable value
     * @return bool|null
     */
    public function getShowOnlyAvailable()
    {
        return $this->ShowOnlyAvailable;
    }
    /**
     * Set ShowOnlyAvailable value
     * @param bool $showOnlyAvailable
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowOnlyAvailable($showOnlyAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnlyAvailable) && !is_bool($showOnlyAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnlyAvailable, true), gettype($showOnlyAvailable)), __LINE__);
        }
        $this->ShowOnlyAvailable = $showOnlyAvailable;
        return $this;
    }
    /**
     * Get ShowAllCombinations value
     * @return bool|null
     */
    public function getShowAllCombinations()
    {
        return $this->ShowAllCombinations;
    }
    /**
     * Set ShowAllCombinations value
     * @param bool $showAllCombinations
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowAllCombinations($showAllCombinations = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAllCombinations) && !is_bool($showAllCombinations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAllCombinations, true), gettype($showAllCombinations)), __LINE__);
        }
        $this->ShowAllCombinations = $showAllCombinations;
        return $this;
    }
    /**
     * Get MaxCombinations value
     * @return int|null
     */
    public function getMaxCombinations()
    {
        return $this->MaxCombinations;
    }
    /**
     * Set MaxCombinations value
     * @param int $maxCombinations
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setMaxCombinations($maxCombinations = null)
    {
        // validation for constraint: int
        if (!is_null($maxCombinations) && !(is_int($maxCombinations) || ctype_digit($maxCombinations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCombinations, true), gettype($maxCombinations)), __LINE__);
        }
        $this->MaxCombinations = $maxCombinations;
        return $this;
    }
    /**
     * Get ShowOnlyBestPriceCombination value
     * @return bool|null
     */
    public function getShowOnlyBestPriceCombination()
    {
        return $this->ShowOnlyBestPriceCombination;
    }
    /**
     * Set ShowOnlyBestPriceCombination value
     * @param bool $showOnlyBestPriceCombination
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowOnlyBestPriceCombination($showOnlyBestPriceCombination = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnlyBestPriceCombination) && !is_bool($showOnlyBestPriceCombination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnlyBestPriceCombination, true), gettype($showOnlyBestPriceCombination)), __LINE__);
        }
        $this->ShowOnlyBestPriceCombination = $showOnlyBestPriceCombination;
        return $this;
    }
    /**
     * Get ShowAllRates value
     * @return bool|null
     */
    public function getShowAllRates()
    {
        return $this->ShowAllRates;
    }
    /**
     * Set ShowAllRates value
     * @param bool $showAllRates
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowAllRates($showAllRates = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAllRates) && !is_bool($showAllRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAllRates, true), gettype($showAllRates)), __LINE__);
        }
        $this->ShowAllRates = $showAllRates;
        return $this;
    }
    /**
     * Get ShowAllPortfolio value
     * @return bool|null
     */
    public function getShowAllPortfolio()
    {
        return $this->ShowAllPortfolio;
    }
    /**
     * Set ShowAllPortfolio value
     * @param bool $showAllPortfolio
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowAllPortfolio($showAllPortfolio = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAllPortfolio) && !is_bool($showAllPortfolio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAllPortfolio, true), gettype($showAllPortfolio)), __LINE__);
        }
        $this->ShowAllPortfolio = $showAllPortfolio;
        return $this;
    }
    /**
     * Get ShowAllChildrenCombinations value
     * @return bool|null
     */
    public function getShowAllChildrenCombinations()
    {
        return $this->ShowAllChildrenCombinations;
    }
    /**
     * Set ShowAllChildrenCombinations value
     * @param bool $showAllChildrenCombinations
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowAllChildrenCombinations($showAllChildrenCombinations = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAllChildrenCombinations) && !is_bool($showAllChildrenCombinations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAllChildrenCombinations, true), gettype($showAllChildrenCombinations)), __LINE__);
        }
        $this->ShowAllChildrenCombinations = $showAllChildrenCombinations;
        return $this;
    }
    /**
     * Get ShowCancellationPolicies value
     * @return bool|null
     */
    public function getShowCancellationPolicies()
    {
        return $this->ShowCancellationPolicies;
    }
    /**
     * Set ShowCancellationPolicies value
     * @param bool $showCancellationPolicies
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowCancellationPolicies($showCancellationPolicies = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCancellationPolicies) && !is_bool($showCancellationPolicies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCancellationPolicies, true), gettype($showCancellationPolicies)), __LINE__);
        }
        $this->ShowCancellationPolicies = $showCancellationPolicies;
        return $this;
    }
    /**
     * Get ExcludeNonRefundable value
     * @return bool|null
     */
    public function getExcludeNonRefundable()
    {
        return $this->ExcludeNonRefundable;
    }
    /**
     * Set ExcludeNonRefundable value
     * @param bool $excludeNonRefundable
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setExcludeNonRefundable($excludeNonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeNonRefundable) && !is_bool($excludeNonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeNonRefundable, true), gettype($excludeNonRefundable)), __LINE__);
        }
        $this->ExcludeNonRefundable = $excludeNonRefundable;
        return $this;
    }
    /**
     * Get ShowDynamicInventory value
     * @return bool|null
     */
    public function getShowDynamicInventory()
    {
        return $this->ShowDynamicInventory;
    }
    /**
     * Set ShowDynamicInventory value
     * @param bool $showDynamicInventory
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowDynamicInventory($showDynamicInventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDynamicInventory) && !is_bool($showDynamicInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showDynamicInventory, true), gettype($showDynamicInventory)), __LINE__);
        }
        $this->ShowDynamicInventory = $showDynamicInventory;
        return $this;
    }
    /**
     * Get ShowCompleteInfo value
     * @return bool|null
     */
    public function getShowCompleteInfo()
    {
        return $this->ShowCompleteInfo;
    }
    /**
     * Set ShowCompleteInfo value
     * @param bool $showCompleteInfo
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowCompleteInfo($showCompleteInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCompleteInfo) && !is_bool($showCompleteInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCompleteInfo, true), gettype($showCompleteInfo)), __LINE__);
        }
        $this->ShowCompleteInfo = $showCompleteInfo;
        return $this;
    }
    /**
     * Get HideRatePlanCode value
     * @return bool|null
     */
    public function getHideRatePlanCode()
    {
        return $this->HideRatePlanCode;
    }
    /**
     * Set HideRatePlanCode value
     * @param bool $hideRatePlanCode
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setHideRatePlanCode($hideRatePlanCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideRatePlanCode) && !is_bool($hideRatePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideRatePlanCode, true), gettype($hideRatePlanCode)), __LINE__);
        }
        $this->HideRatePlanCode = $hideRatePlanCode;
        return $this;
    }
    /**
     * Get TimeOut value
     * @return int|null
     */
    public function getTimeOut()
    {
        return $this->TimeOut;
    }
    /**
     * Set TimeOut value
     * @param int $timeOut
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setTimeOut($timeOut = null)
    {
        // validation for constraint: int
        if (!is_null($timeOut) && !(is_int($timeOut) || ctype_digit($timeOut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeOut, true), gettype($timeOut)), __LINE__);
        }
        $this->TimeOut = $timeOut;
        return $this;
    }
    /**
     * Get ShowAvailabilityBreakdown value
     * @return bool|null
     */
    public function getShowAvailabilityBreakdown()
    {
        return $this->ShowAvailabilityBreakdown;
    }
    /**
     * Set ShowAvailabilityBreakdown value
     * @param bool $showAvailabilityBreakdown
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setShowAvailabilityBreakdown($showAvailabilityBreakdown = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAvailabilityBreakdown) && !is_bool($showAvailabilityBreakdown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAvailabilityBreakdown, true), gettype($showAvailabilityBreakdown)), __LINE__);
        }
        $this->ShowAvailabilityBreakdown = $showAvailabilityBreakdown;
        return $this;
    }
    /**
     * Get MinimumPrice value
     * @return float|null
     */
    public function getMinimumPrice()
    {
        return $this->MinimumPrice;
    }
    /**
     * Set MinimumPrice value
     * @param float $minimumPrice
     * @return \StructType\JP_HotelAvailAdvancedOptions
     */
    public function setMinimumPrice($minimumPrice = null)
    {
        // validation for constraint: float
        if (!is_null($minimumPrice) && !(is_float($minimumPrice) || is_numeric($minimumPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumPrice, true), gettype($minimumPrice)), __LINE__);
        }
        $this->MinimumPrice = $minimumPrice;
        return $this;
    }
}
