<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_Ages StructType
 * @subpackage Structs
 */
class JPSOAP_Ages extends AbstractStructBase
{
    /**
     * The Infants
     * @var int
     */
    public $Infants;
    /**
     * The ChildA
     * @var int
     */
    public $ChildA;
    /**
     * The ChildB
     * @var int
     */
    public $ChildB;
    /**
     * The InfantAsChild
     * @var int
     */
    public $InfantAsChild;
    /**
     * Constructor method for JPSOAP_Ages
     * @uses JPSOAP_Ages::setInfants()
     * @uses JPSOAP_Ages::setChildA()
     * @uses JPSOAP_Ages::setChildB()
     * @uses JPSOAP_Ages::setInfantAsChild()
     * @param int $infants
     * @param int $childA
     * @param int $childB
     * @param int $infantAsChild
     */
    public function __construct($infants = null, $childA = null, $childB = null, $infantAsChild = null)
    {
        $this
            ->setInfants($infants)
            ->setChildA($childA)
            ->setChildB($childB)
            ->setInfantAsChild($infantAsChild);
    }
    /**
     * Get Infants value
     * @return int|null
     */
    public function getInfants()
    {
        return $this->Infants;
    }
    /**
     * Set Infants value
     * @param int $infants
     * @return \StructType\JPSOAP_Ages
     */
    public function setInfants($infants = null)
    {
        // validation for constraint: int
        if (!is_null($infants) && !(is_int($infants) || ctype_digit($infants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($infants, true), gettype($infants)), __LINE__);
        }
        $this->Infants = $infants;
        return $this;
    }
    /**
     * Get ChildA value
     * @return int|null
     */
    public function getChildA()
    {
        return $this->ChildA;
    }
    /**
     * Set ChildA value
     * @param int $childA
     * @return \StructType\JPSOAP_Ages
     */
    public function setChildA($childA = null)
    {
        // validation for constraint: int
        if (!is_null($childA) && !(is_int($childA) || ctype_digit($childA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childA, true), gettype($childA)), __LINE__);
        }
        $this->ChildA = $childA;
        return $this;
    }
    /**
     * Get ChildB value
     * @return int|null
     */
    public function getChildB()
    {
        return $this->ChildB;
    }
    /**
     * Set ChildB value
     * @param int $childB
     * @return \StructType\JPSOAP_Ages
     */
    public function setChildB($childB = null)
    {
        // validation for constraint: int
        if (!is_null($childB) && !(is_int($childB) || ctype_digit($childB))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childB, true), gettype($childB)), __LINE__);
        }
        $this->ChildB = $childB;
        return $this;
    }
    /**
     * Get InfantAsChild value
     * @return int|null
     */
    public function getInfantAsChild()
    {
        return $this->InfantAsChild;
    }
    /**
     * Set InfantAsChild value
     * @param int $infantAsChild
     * @return \StructType\JPSOAP_Ages
     */
    public function setInfantAsChild($infantAsChild = null)
    {
        // validation for constraint: int
        if (!is_null($infantAsChild) && !(is_int($infantAsChild) || ctype_digit($infantAsChild))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($infantAsChild, true), gettype($infantAsChild)), __LINE__);
        }
        $this->InfantAsChild = $infantAsChild;
        return $this;
    }
}
