<?php

namespace EnumType;

/**
 * This class stands for JP_RequiredFieldType EnumType
 * @subpackage Enumerations
 */
class JP_RequiredFieldType
{
    /**
     * Constant for value 'String'
     * @return string 'String'
     */
    const VALUE_STRING = 'String';
    /**
     * Constant for value 'Integer'
     * @return string 'Integer'
     */
    const VALUE_INTEGER = 'Integer';
    /**
     * Constant for value 'Datetime'
     * @return string 'Datetime'
     */
    const VALUE_DATETIME = 'Datetime';
    /**
     * Constant for value 'Decimal'
     * @return string 'Decimal'
     */
    const VALUE_DECIMAL = 'Decimal';
    /**
     * Constant for value 'Boolean'
     * @return string 'Boolean'
     */
    const VALUE_BOOLEAN = 'Boolean';
    /**
     * Constant for value 'Enum'
     * @return string 'Enum'
     */
    const VALUE_ENUM = 'Enum';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STRING
     * @uses self::VALUE_INTEGER
     * @uses self::VALUE_DATETIME
     * @uses self::VALUE_DECIMAL
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_ENUM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STRING,
            self::VALUE_INTEGER,
            self::VALUE_DATETIME,
            self::VALUE_DECIMAL,
            self::VALUE_BOOLEAN,
            self::VALUE_ENUM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
