<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FlightBookingRules StructType
 * @subpackage Structs
 */
class JP_FlightBookingRules extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The LowCost
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $LowCost;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The FlightRequiredFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FlightRequiredFields
     */
    public $FlightRequiredFields;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The AdditionalPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_AdditionalPoliciesGroup
     */
    public $AdditionalPolicies;
    /**
     * The PriceInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FlightPriceInformation
     */
    public $PriceInformation;
    /**
     * The OptionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_OptionalElements
     */
    public $OptionalElements;
    /**
     * The FareGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FareGroup
     */
    public $FareGroup;
    /**
     * The Source
     * @var string
     */
    public $Source;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The Additionalnformation
     * @var string
     */
    public $Additionalnformation;
    /**
     * Constructor method for JP_FlightBookingRules
     * @uses JP_FlightBookingRules::setStatus()
     * @uses JP_FlightBookingRules::setLowCost()
     * @uses JP_FlightBookingRules::setBookingCode()
     * @uses JP_FlightBookingRules::setFlightRequiredFields()
     * @uses JP_FlightBookingRules::setCancellationPolicy()
     * @uses JP_FlightBookingRules::setCancellationPolicyCost()
     * @uses JP_FlightBookingRules::setAdditionalPolicies()
     * @uses JP_FlightBookingRules::setPriceInformation()
     * @uses JP_FlightBookingRules::setOptionalElements()
     * @uses JP_FlightBookingRules::setFareGroup()
     * @uses JP_FlightBookingRules::setSource()
     * @uses JP_FlightBookingRules::setDirection()
     * @uses JP_FlightBookingRules::setAdditionalnformation()
     * @param string $status
     * @param bool $lowCost
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_FlightRequiredFields $flightRequiredFields
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \ArrayType\ArrayOfJP_AdditionalPoliciesGroup $additionalPolicies
     * @param \StructType\JP_FlightPriceInformation $priceInformation
     * @param \StructType\JP_OptionalElements $optionalElements
     * @param \StructType\JP_FareGroup $fareGroup
     * @param string $source
     * @param string $direction
     * @param string $additionalnformation
     */
    public function __construct($status = null, $lowCost = null, \StructType\JP_BookingCode $bookingCode = null, \StructType\JP_FlightRequiredFields $flightRequiredFields = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \ArrayType\ArrayOfJP_AdditionalPoliciesGroup $additionalPolicies = null, \StructType\JP_FlightPriceInformation $priceInformation = null, \StructType\JP_OptionalElements $optionalElements = null, \StructType\JP_FareGroup $fareGroup = null, $source = null, $direction = null, $additionalnformation = null)
    {
        $this
            ->setStatus($status)
            ->setLowCost($lowCost)
            ->setBookingCode($bookingCode)
            ->setFlightRequiredFields($flightRequiredFields)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setAdditionalPolicies($additionalPolicies)
            ->setPriceInformation($priceInformation)
            ->setOptionalElements($optionalElements)
            ->setFareGroup($fareGroup)
            ->setSource($source)
            ->setDirection($direction)
            ->setAdditionalnformation($additionalnformation);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_FlightBookingRules
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get LowCost value
     * @return bool
     */
    public function getLowCost()
    {
        return $this->LowCost;
    }
    /**
     * Set LowCost value
     * @param bool $lowCost
     * @return \StructType\JP_FlightBookingRules
     */
    public function setLowCost($lowCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($lowCost) && !is_bool($lowCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lowCost, true), gettype($lowCost)), __LINE__);
        }
        $this->LowCost = $lowCost;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_FlightBookingRules
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get FlightRequiredFields value
     * @return \StructType\JP_FlightRequiredFields|null
     */
    public function getFlightRequiredFields()
    {
        return $this->FlightRequiredFields;
    }
    /**
     * Set FlightRequiredFields value
     * @param \StructType\JP_FlightRequiredFields $flightRequiredFields
     * @return \StructType\JP_FlightBookingRules
     */
    public function setFlightRequiredFields(\StructType\JP_FlightRequiredFields $flightRequiredFields = null)
    {
        $this->FlightRequiredFields = $flightRequiredFields;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_FlightBookingRules
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_FlightBookingRules
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get AdditionalPolicies value
     * @return \ArrayType\ArrayOfJP_AdditionalPoliciesGroup|null
     */
    public function getAdditionalPolicies()
    {
        return $this->AdditionalPolicies;
    }
    /**
     * Set AdditionalPolicies value
     * @param \ArrayType\ArrayOfJP_AdditionalPoliciesGroup $additionalPolicies
     * @return \StructType\JP_FlightBookingRules
     */
    public function setAdditionalPolicies(\ArrayType\ArrayOfJP_AdditionalPoliciesGroup $additionalPolicies = null)
    {
        $this->AdditionalPolicies = $additionalPolicies;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_FlightPriceInformation|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_FlightPriceInformation $priceInformation
     * @return \StructType\JP_FlightBookingRules
     */
    public function setPriceInformation(\StructType\JP_FlightPriceInformation $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_OptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_OptionalElements $optionalElements
     * @return \StructType\JP_FlightBookingRules
     */
    public function setOptionalElements(\StructType\JP_OptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get FareGroup value
     * @return \StructType\JP_FareGroup|null
     */
    public function getFareGroup()
    {
        return $this->FareGroup;
    }
    /**
     * Set FareGroup value
     * @param \StructType\JP_FareGroup $fareGroup
     * @return \StructType\JP_FlightBookingRules
     */
    public function setFareGroup(\StructType\JP_FareGroup $fareGroup = null)
    {
        $this->FareGroup = $fareGroup;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_FlightBookingRules
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\JP_FlightBookingRules
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Additionalnformation value
     * @return string|null
     */
    public function getAdditionalnformation()
    {
        return $this->Additionalnformation;
    }
    /**
     * Set Additionalnformation value
     * @param string $additionalnformation
     * @return \StructType\JP_FlightBookingRules
     */
    public function setAdditionalnformation($additionalnformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalnformation) && !is_string($additionalnformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalnformation, true), gettype($additionalnformation)), __LINE__);
        }
        $this->Additionalnformation = $additionalnformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FlightBookingRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
