<?php

namespace EnumType;

/**
 * This class stands for JP_DocumentType EnumType
 * @subpackage Enumerations
 */
class JP_DocumentType
{
    /**
     * Constant for value 'PAS'
     * @return string 'PAS'
     */
    const VALUE_PAS = 'PAS';
    /**
     * Constant for value 'NIF'
     * @return string 'NIF'
     */
    const VALUE_NIF = 'NIF';
    /**
     * Constant for value 'DNI'
     * @return string 'DNI'
     */
    const VALUE_DNI = 'DNI';
    /**
     * Constant for value 'CIF'
     * @return string 'CIF'
     */
    const VALUE_CIF = 'CIF';
    /**
     * Constant for value 'NIE'
     * @return string 'NIE'
     */
    const VALUE_NIE = 'NIE';
    /**
     * Constant for value 'CPF'
     * @return string 'CPF'
     */
    const VALUE_CPF = 'CPF';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAS
     * @uses self::VALUE_NIF
     * @uses self::VALUE_DNI
     * @uses self::VALUE_CIF
     * @uses self::VALUE_NIE
     * @uses self::VALUE_CPF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAS,
            self::VALUE_NIF,
            self::VALUE_DNI,
            self::VALUE_CIF,
            self::VALUE_NIE,
            self::VALUE_CPF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
