<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://xml2.bookingengine.es/WebService/JP/WebServiceJP.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://xml2.bookingengine.es/WebService/JP/WebServiceJP.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckPaymentRequiredField operation/method
 */
if ($check->CheckPaymentRequiredField(new \StructType\CheckPaymentRequiredField()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckPayment operation/method
 */
if ($check->CheckPayment(new \StructType\CheckPayment()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Payment ServiceType
 */
$payment = new \ServiceType\Payment($options);
/**
 * Sample call for PaymentBooking operation/method
 */
if ($payment->PaymentBooking(new \StructType\PaymentBooking()) !== false) {
    print_r($payment->getResult());
} else {
    print_r($payment->getLastError());
}
/**
 * Samples for Shopping ServiceType
 */
$shopping = new \ServiceType\Shopping($options);
/**
 * Sample call for ShoppingBasketRead operation/method
 */
if ($shopping->ShoppingBasketRead(new \StructType\ShoppingBasketRead()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingBasketSave operation/method
 */
if ($shopping->ShoppingBasketSave(new \StructType\ShoppingBasketSave()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Samples for Hotel ServiceType
 */
$hotel = new \ServiceType\Hotel($options);
/**
 * Sample call for HotelBooking operation/method
 */
if ($hotel->HotelBooking(new \StructType\HotelBooking()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelModify operation/method
 */
if ($hotel->HotelModify(new \StructType\HotelModify()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelConfirmModify operation/method
 */
if ($hotel->HotelConfirmModify(new \StructType\HotelConfirmModify()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelAvail operation/method
 */
if ($hotel->HotelAvail(new \StructType\HotelAvail()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelAvailCalendar operation/method
 */
if ($hotel->HotelAvailCalendar(new \StructType\HotelAvailCalendar()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelFutureRates operation/method
 */
if ($hotel->HotelFutureRates(new \StructType\HotelFutureRates()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelAllotment operation/method
 */
if ($hotel->HotelAllotment(new \StructType\HotelAllotment()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelRates operation/method
 */
if ($hotel->HotelRates(new \StructType\HotelRates()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelSpecifications operation/method
 */
if ($hotel->HotelSpecifications(new \StructType\HotelSpecifications()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelListInventory operation/method
 */
if ($hotel->HotelListInventory(new \StructType\HotelListInventory()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelCatalogueData operation/method
 */
if ($hotel->HotelCatalogueData(new \StructType\HotelCatalogueData()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelList operation/method
 */
if ($hotel->HotelList(new \StructType\HotelList()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelPortfolio operation/method
 */
if ($hotel->HotelPortfolio(new \StructType\HotelPortfolio()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelContent operation/method
 */
if ($hotel->HotelContent(new \StructType\HotelContent()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelCheckAvail operation/method
 */
if ($hotel->HotelCheckAvail(new \StructType\HotelCheckAvail()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelBookingRules operation/method
 */
if ($hotel->HotelBookingRules(new \StructType\HotelBookingRules()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Samples for Rentacar ServiceType
 */
$rentacar = new \ServiceType\Rentacar($options);
/**
 * Sample call for RentacarBooking operation/method
 */
if ($rentacar->RentacarBooking(new \StructType\RentacarBooking()) !== false) {
    print_r($rentacar->getResult());
} else {
    print_r($rentacar->getLastError());
}
/**
 * Sample call for RentacarAvail operation/method
 */
if ($rentacar->RentacarAvail(new \StructType\RentacarAvail()) !== false) {
    print_r($rentacar->getResult());
} else {
    print_r($rentacar->getLastError());
}
/**
 * Sample call for RentacarLocationList operation/method
 */
if ($rentacar->RentacarLocationList(new \StructType\RentacarLocationList()) !== false) {
    print_r($rentacar->getResult());
} else {
    print_r($rentacar->getLastError());
}
/**
 * Sample call for RentacarLocationContent operation/method
 */
if ($rentacar->RentacarLocationContent(new \StructType\RentacarLocationContent()) !== false) {
    print_r($rentacar->getResult());
} else {
    print_r($rentacar->getLastError());
}
/**
 * Sample call for RentacarCheckAvail operation/method
 */
if ($rentacar->RentacarCheckAvail(new \StructType\RentacarCheckAvail()) !== false) {
    print_r($rentacar->getResult());
} else {
    print_r($rentacar->getLastError());
}
/**
 * Sample call for RentacarBookingRules operation/method
 */
if ($rentacar->RentacarBookingRules(new \StructType\RentacarBookingRules()) !== false) {
    print_r($rentacar->getResult());
} else {
    print_r($rentacar->getLastError());
}
/**
 * Samples for Insurance ServiceType
 */
$insurance = new \ServiceType\Insurance($options);
/**
 * Sample call for InsuranceBooking operation/method
 */
if ($insurance->InsuranceBooking(new \StructType\InsuranceBooking()) !== false) {
    print_r($insurance->getResult());
} else {
    print_r($insurance->getLastError());
}
/**
 * Sample call for InsuranceAvail operation/method
 */
if ($insurance->InsuranceAvail(new \StructType\InsuranceAvail()) !== false) {
    print_r($insurance->getResult());
} else {
    print_r($insurance->getLastError());
}
/**
 * Sample call for InsuranceCheckAvail operation/method
 */
if ($insurance->InsuranceCheckAvail(new \StructType\InsuranceCheckAvail()) !== false) {
    print_r($insurance->getResult());
} else {
    print_r($insurance->getLastError());
}
/**
 * Sample call for InsuranceBookingRules operation/method
 */
if ($insurance->InsuranceBookingRules(new \StructType\InsuranceBookingRules()) !== false) {
    print_r($insurance->getResult());
} else {
    print_r($insurance->getLastError());
}
/**
 * Samples for Package ServiceType
 */
$package = new \ServiceType\Package($options);
/**
 * Sample call for PackageBooking operation/method
 */
if ($package->PackageBooking(new \StructType\PackageBooking()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Sample call for PackageAvail operation/method
 */
if ($package->PackageAvail(new \StructType\PackageAvail()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Sample call for PackageChangeProduct operation/method
 */
if ($package->PackageChangeProduct(new \StructType\PackageChangeProduct()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Sample call for PackageList operation/method
 */
if ($package->PackageList(new \StructType\PackageList()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Sample call for PackageCalendarPrice operation/method
 */
if ($package->PackageCalendarPrice(new \StructType\PackageCalendarPrice()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Sample call for PackageSearcher operation/method
 */
if ($package->PackageSearcher(new \StructType\PackageSearcher()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Sample call for PackageContent operation/method
 */
if ($package->PackageContent(new \StructType\PackageContent()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Sample call for PackageCheckAvail operation/method
 */
if ($package->PackageCheckAvail(new \StructType\PackageCheckAvail()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Sample call for PackageBookingRules operation/method
 */
if ($package->PackageBookingRules(new \StructType\PackageBookingRules()) !== false) {
    print_r($package->getResult());
} else {
    print_r($package->getLastError());
}
/**
 * Samples for Flight ServiceType
 */
$flight = new \ServiceType\Flight($options);
/**
 * Sample call for FlightBooking operation/method
 */
if ($flight->FlightBooking(new \StructType\FlightBooking()) !== false) {
    print_r($flight->getResult());
} else {
    print_r($flight->getLastError());
}
/**
 * Sample call for FlightTicketing operation/method
 */
if ($flight->FlightTicketing(new \StructType\FlightTicketing()) !== false) {
    print_r($flight->getResult());
} else {
    print_r($flight->getLastError());
}
/**
 * Sample call for FlightAvail operation/method
 */
if ($flight->FlightAvail(new \StructType\FlightAvail()) !== false) {
    print_r($flight->getResult());
} else {
    print_r($flight->getLastError());
}
/**
 * Sample call for FlightCheckAvail operation/method
 */
if ($flight->FlightCheckAvail(new \StructType\FlightCheckAvail()) !== false) {
    print_r($flight->getResult());
} else {
    print_r($flight->getLastError());
}
/**
 * Sample call for FlightBookingRules operation/method
 */
if ($flight->FlightBookingRules(new \StructType\FlightBookingRules()) !== false) {
    print_r($flight->getResult());
} else {
    print_r($flight->getLastError());
}
/**
 * Samples for Cruise ServiceType
 */
$cruise = new \ServiceType\Cruise($options);
/**
 * Sample call for CruiseBooking operation/method
 */
if ($cruise->CruiseBooking(new \StructType\CruiseBooking()) !== false) {
    print_r($cruise->getResult());
} else {
    print_r($cruise->getLastError());
}
/**
 * Sample call for CruisePreAvail operation/method
 */
if ($cruise->CruisePreAvail(new \StructType\CruisePreAvail()) !== false) {
    print_r($cruise->getResult());
} else {
    print_r($cruise->getLastError());
}
/**
 * Sample call for CruiseAvail operation/method
 */
if ($cruise->CruiseAvail(new \StructType\CruiseAvail()) !== false) {
    print_r($cruise->getResult());
} else {
    print_r($cruise->getLastError());
}
/**
 * Sample call for CruiseItinerary operation/method
 */
if ($cruise->CruiseItinerary(new \StructType\CruiseItinerary()) !== false) {
    print_r($cruise->getResult());
} else {
    print_r($cruise->getLastError());
}
/**
 * Sample call for CruiseShip operation/method
 */
if ($cruise->CruiseShip(new \StructType\CruiseShip()) !== false) {
    print_r($cruise->getResult());
} else {
    print_r($cruise->getLastError());
}
/**
 * Sample call for CruiseDataList operation/method
 */
if ($cruise->CruiseDataList(new \StructType\CruiseDataList()) !== false) {
    print_r($cruise->getResult());
} else {
    print_r($cruise->getLastError());
}
/**
 * Sample call for CruiseCheckAvail operation/method
 */
if ($cruise->CruiseCheckAvail(new \StructType\CruiseCheckAvail()) !== false) {
    print_r($cruise->getResult());
} else {
    print_r($cruise->getLastError());
}
/**
 * Sample call for CruiseBookingRules operation/method
 */
if ($cruise->CruiseBookingRules(new \StructType\CruiseBookingRules()) !== false) {
    print_r($cruise->getResult());
} else {
    print_r($cruise->getLastError());
}
/**
 * Samples for Service ServiceType
 */
$service = new \ServiceType\Service($options);
/**
 * Sample call for ServiceBooking operation/method
 */
if ($service->ServiceBooking(new \StructType\ServiceBooking()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ServiceModify operation/method
 */
if ($service->ServiceModify(new \StructType\ServiceModify()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ServiceConfirmModify operation/method
 */
if ($service->ServiceConfirmModify(new \StructType\ServiceConfirmModify()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ServiceAvail operation/method
 */
if ($service->ServiceAvail(new \StructType\ServiceAvail()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ServiceCatalogueData operation/method
 */
if ($service->ServiceCatalogueData(new \StructType\ServiceCatalogueData()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ServicePortfolio operation/method
 */
if ($service->ServicePortfolio(new \StructType\ServicePortfolio()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ServiceContent operation/method
 */
if ($service->ServiceContent(new \StructType\ServiceContent()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ServiceCheckAvail operation/method
 */
if ($service->ServiceCheckAvail(new \StructType\ServiceCheckAvail()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ServiceBookingRules operation/method
 */
if ($service->ServiceBookingRules(new \StructType\ServiceBookingRules()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Samples for Transfer ServiceType
 */
$transfer = new \ServiceType\Transfer($options);
/**
 * Sample call for TransferBooking operation/method
 */
if ($transfer->TransferBooking(new \StructType\TransferBooking()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferModify operation/method
 */
if ($transfer->TransferModify(new \StructType\TransferModify()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferConfirmModify operation/method
 */
if ($transfer->TransferConfirmModify(new \StructType\TransferConfirmModify()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferAvail operation/method
 */
if ($transfer->TransferAvail(new \StructType\TransferAvail()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferAvailByHotel operation/method
 */
if ($transfer->TransferAvailByHotel(new \StructType\TransferAvailByHotel()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferPortfolio operation/method
 */
if ($transfer->TransferPortfolio(new \StructType\TransferPortfolio()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferCatalogueData operation/method
 */
if ($transfer->TransferCatalogueData(new \StructType\TransferCatalogueData()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferContent operation/method
 */
if ($transfer->TransferContent(new \StructType\TransferContent()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferCheckAvail operation/method
 */
if ($transfer->TransferCheckAvail(new \StructType\TransferCheckAvail()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferBookingRules operation/method
 */
if ($transfer->TransferBookingRules(new \StructType\TransferBookingRules()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Samples for Visa ServiceType
 */
$visa = new \ServiceType\Visa($options);
/**
 * Sample call for VisaBooking operation/method
 */
if ($visa->VisaBooking(new \StructType\VisaBooking()) !== false) {
    print_r($visa->getResult());
} else {
    print_r($visa->getLastError());
}
/**
 * Sample call for VisaModify operation/method
 */
if ($visa->VisaModify(new \StructType\VisaModify()) !== false) {
    print_r($visa->getResult());
} else {
    print_r($visa->getLastError());
}
/**
 * Sample call for VisaConfirmModify operation/method
 */
if ($visa->VisaConfirmModify(new \StructType\VisaConfirmModify()) !== false) {
    print_r($visa->getResult());
} else {
    print_r($visa->getLastError());
}
/**
 * Sample call for VisaAvail operation/method
 */
if ($visa->VisaAvail(new \StructType\VisaAvail()) !== false) {
    print_r($visa->getResult());
} else {
    print_r($visa->getLastError());
}
/**
 * Sample call for VisaPortfolio operation/method
 */
if ($visa->VisaPortfolio(new \StructType\VisaPortfolio()) !== false) {
    print_r($visa->getResult());
} else {
    print_r($visa->getLastError());
}
/**
 * Sample call for VisaCatalogueData operation/method
 */
if ($visa->VisaCatalogueData(new \StructType\VisaCatalogueData()) !== false) {
    print_r($visa->getResult());
} else {
    print_r($visa->getLastError());
}
/**
 * Sample call for VisaCheckAvail operation/method
 */
if ($visa->VisaCheckAvail(new \StructType\VisaCheckAvail()) !== false) {
    print_r($visa->getResult());
} else {
    print_r($visa->getLastError());
}
/**
 * Sample call for VisaBookingRules operation/method
 */
if ($visa->VisaBookingRules(new \StructType\VisaBookingRules()) !== false) {
    print_r($visa->getResult());
} else {
    print_r($visa->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelBooking operation/method
 */
if ($cancel->CancelBooking(new \StructType\CancelBooking()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Read ServiceType
 */
$read = new \ServiceType\Read($options);
/**
 * Sample call for ReadBooking operation/method
 */
if ($read->ReadBooking(new \StructType\ReadBooking()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Samples for Booking ServiceType
 */
$booking = new \ServiceType\Booking($options);
/**
 * Sample call for BookingList operation/method
 */
if ($booking->BookingList(new \StructType\BookingList()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Samples for Final ServiceType
 */
$final = new \ServiceType\_Final($options);
/**
 * Sample call for FinalCustomerSave operation/method
 */
if ($final->FinalCustomerSave(new \StructType\FinalCustomerSave()) !== false) {
    print_r($final->getResult());
} else {
    print_r($final->getLastError());
}
/**
 * Sample call for FinalCustomerRead operation/method
 */
if ($final->FinalCustomerRead(new \StructType\FinalCustomerRead()) !== false) {
    print_r($final->getResult());
} else {
    print_r($final->getLastError());
}
/**
 * Samples for Customer ServiceType
 */
$customer = new \ServiceType\Customer($options);
/**
 * Sample call for CustomerRead operation/method
 */
if ($customer->CustomerRead(new \StructType\CustomerRead()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Samples for Agency ServiceType
 */
$agency = new \ServiceType\Agency($options);
/**
 * Sample call for AgencyRead operation/method
 */
if ($agency->AgencyRead(new \StructType\AgencyRead()) !== false) {
    print_r($agency->getResult());
} else {
    print_r($agency->getLastError());
}
/**
 * Samples for Supplier ServiceType
 */
$supplier = new \ServiceType\Supplier($options);
/**
 * Sample call for SupplierList operation/method
 */
if ($supplier->SupplierList(new \StructType\SupplierList()) !== false) {
    print_r($supplier->getResult());
} else {
    print_r($supplier->getLastError());
}
/**
 * Samples for Generic ServiceType
 */
$generic = new \ServiceType\Generic($options);
/**
 * Sample call for GenericDataCatalogue operation/method
 */
if ($generic->GenericDataCatalogue(new \StructType\GenericDataCatalogue()) !== false) {
    print_r($generic->getResult());
} else {
    print_r($generic->getLastError());
}
/**
 * Samples for Zone ServiceType
 */
$zone = new \ServiceType\Zone($options);
/**
 * Sample call for ZoneList operation/method
 */
if ($zone->ZoneList(new \StructType\ZoneList()) !== false) {
    print_r($zone->getResult());
} else {
    print_r($zone->getLastError());
}
/**
 * Samples for City ServiceType
 */
$city = new \ServiceType\City($options);
/**
 * Sample call for CityList operation/method
 */
if ($city->CityList(new \StructType\CityList()) !== false) {
    print_r($city->getResult());
} else {
    print_r($city->getLastError());
}
/**
 * Samples for Accommodation ServiceType
 */
$accommodation = new \ServiceType\Accommodation($options);
/**
 * Sample call for AccommodationPortfolio operation/method
 */
if ($accommodation->AccommodationPortfolio(new \StructType\AccommodationPortfolio()) !== false) {
    print_r($accommodation->getResult());
} else {
    print_r($accommodation->getLastError());
}
/**
 * Samples for Room ServiceType
 */
$room = new \ServiceType\Room($options);
/**
 * Sample call for RoomList operation/method
 */
if ($room->RoomList(new \StructType\RoomList()) !== false) {
    print_r($room->getResult());
} else {
    print_r($room->getLastError());
}
/**
 * Samples for Meeting ServiceType
 */
$meeting = new \ServiceType\Meeting($options);
/**
 * Sample call for MeetingPointList operation/method
 */
if ($meeting->MeetingPointList(new \StructType\MeetingPointList()) !== false) {
    print_r($meeting->getResult());
} else {
    print_r($meeting->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetZoneInfoList operation/method
 */
if ($get->GetZoneInfoList(new \StructType\GetZoneInfoList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPermissionList operation/method
 */
if ($get->GetPermissionList(new \StructType\GetPermissionList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
