<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentsInsurance StructType
 * @subpackage Structs
 */
class JP_SearchSegmentsInsurance extends AbstractStructBase
{
    /**
     * The SearchSegmentInsurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_SearchSegmentInsurance
     */
    public $SearchSegmentInsurance;
    /**
     * The CountryOfResidence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfResidence;
    /**
     * The Suppliers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString3
     */
    public $Suppliers;
    /**
     * The ProductTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ProductType
     */
    public $ProductTypes;
    /**
     * Constructor method for JP_SearchSegmentsInsurance
     * @uses JP_SearchSegmentsInsurance::setSearchSegmentInsurance()
     * @uses JP_SearchSegmentsInsurance::setCountryOfResidence()
     * @uses JP_SearchSegmentsInsurance::setSuppliers()
     * @uses JP_SearchSegmentsInsurance::setProductTypes()
     * @param \StructType\JP_SearchSegmentInsurance $searchSegmentInsurance
     * @param string $countryOfResidence
     * @param \ArrayType\ArrayOfString3 $suppliers
     * @param \ArrayType\ArrayOfJP_ProductType $productTypes
     */
    public function __construct(\StructType\JP_SearchSegmentInsurance $searchSegmentInsurance = null, $countryOfResidence = null, \ArrayType\ArrayOfString3 $suppliers = null, \ArrayType\ArrayOfJP_ProductType $productTypes = null)
    {
        $this
            ->setSearchSegmentInsurance($searchSegmentInsurance)
            ->setCountryOfResidence($countryOfResidence)
            ->setSuppliers($suppliers)
            ->setProductTypes($productTypes);
    }
    /**
     * Get SearchSegmentInsurance value
     * @return \StructType\JP_SearchSegmentInsurance|null
     */
    public function getSearchSegmentInsurance()
    {
        return $this->SearchSegmentInsurance;
    }
    /**
     * Set SearchSegmentInsurance value
     * @param \StructType\JP_SearchSegmentInsurance $searchSegmentInsurance
     * @return \StructType\JP_SearchSegmentsInsurance
     */
    public function setSearchSegmentInsurance(\StructType\JP_SearchSegmentInsurance $searchSegmentInsurance = null)
    {
        $this->SearchSegmentInsurance = $searchSegmentInsurance;
        return $this;
    }
    /**
     * Get CountryOfResidence value
     * @return string|null
     */
    public function getCountryOfResidence()
    {
        return $this->CountryOfResidence;
    }
    /**
     * Set CountryOfResidence value
     * @param string $countryOfResidence
     * @return \StructType\JP_SearchSegmentsInsurance
     */
    public function setCountryOfResidence($countryOfResidence = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfResidence) && !is_string($countryOfResidence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfResidence)), __LINE__);
        }
        $this->CountryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get Suppliers value
     * @return \ArrayType\ArrayOfString3|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \ArrayType\ArrayOfString3 $suppliers
     * @return \StructType\JP_SearchSegmentsInsurance
     */
    public function setSuppliers(\ArrayType\ArrayOfString3 $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get ProductTypes value
     * @return \ArrayType\ArrayOfJP_ProductType|null
     */
    public function getProductTypes()
    {
        return $this->ProductTypes;
    }
    /**
     * Set ProductTypes value
     * @param \ArrayType\ArrayOfJP_ProductType $productTypes
     * @return \StructType\JP_SearchSegmentsInsurance
     */
    public function setProductTypes(\ArrayType\ArrayOfJP_ProductType $productTypes = null)
    {
        $this->ProductTypes = $productTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SearchSegmentsInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
