<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Rule StructType
 * @subpackage Structs
 */
class JP_Rule extends AbstractStructBase
{
    /**
     * The From
     * @var int
     */
    public $From;
    /**
     * The To
     * @var int
     */
    public $To;
    /**
     * The DateFrom
     * @var string
     */
    public $DateFrom;
    /**
     * The DateFromHour
     * @var string
     */
    public $DateFromHour;
    /**
     * The DateTo
     * @var string
     */
    public $DateTo;
    /**
     * The DateToHour
     * @var string
     */
    public $DateToHour;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The FixedPrice
     * @var float
     */
    public $FixedPrice;
    /**
     * The PercentPrice
     * @var float
     */
    public $PercentPrice;
    /**
     * The FirstNightPrice
     * @var float
     */
    public $FirstNightPrice;
    /**
     * The Nights
     * @var int
     */
    public $Nights;
    /**
     * The StayLengthFrom
     * @var int
     */
    public $StayLengthFrom;
    /**
     * The StayLengthTo
     * @var int
     */
    public $StayLengthTo;
    /**
     * The ApplicationTypeNights
     * @var string
     */
    public $ApplicationTypeNights;
    /**
     * Constructor method for JP_Rule
     * @uses JP_Rule::setFrom()
     * @uses JP_Rule::setTo()
     * @uses JP_Rule::setDateFrom()
     * @uses JP_Rule::setDateFromHour()
     * @uses JP_Rule::setDateTo()
     * @uses JP_Rule::setDateToHour()
     * @uses JP_Rule::setType()
     * @uses JP_Rule::setFixedPrice()
     * @uses JP_Rule::setPercentPrice()
     * @uses JP_Rule::setFirstNightPrice()
     * @uses JP_Rule::setNights()
     * @uses JP_Rule::setStayLengthFrom()
     * @uses JP_Rule::setStayLengthTo()
     * @uses JP_Rule::setApplicationTypeNights()
     * @param int $from
     * @param int $to
     * @param string $dateFrom
     * @param string $dateFromHour
     * @param string $dateTo
     * @param string $dateToHour
     * @param string $type
     * @param float $fixedPrice
     * @param float $percentPrice
     * @param float $firstNightPrice
     * @param int $nights
     * @param int $stayLengthFrom
     * @param int $stayLengthTo
     * @param string $applicationTypeNights
     */
    public function __construct($from = null, $to = null, $dateFrom = null, $dateFromHour = null, $dateTo = null, $dateToHour = null, $type = null, $fixedPrice = null, $percentPrice = null, $firstNightPrice = null, $nights = null, $stayLengthFrom = null, $stayLengthTo = null, $applicationTypeNights = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setDateFrom($dateFrom)
            ->setDateFromHour($dateFromHour)
            ->setDateTo($dateTo)
            ->setDateToHour($dateToHour)
            ->setType($type)
            ->setFixedPrice($fixedPrice)
            ->setPercentPrice($percentPrice)
            ->setFirstNightPrice($firstNightPrice)
            ->setNights($nights)
            ->setStayLengthFrom($stayLengthFrom)
            ->setStayLengthTo($stayLengthTo)
            ->setApplicationTypeNights($applicationTypeNights);
    }
    /**
     * Get From value
     * @return int|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param int $from
     * @return \StructType\JP_Rule
     */
    public function setFrom($from = null)
    {
        // validation for constraint: int
        if (!is_null($from) && !is_numeric($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return int|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param int $to
     * @return \StructType\JP_Rule
     */
    public function setTo($to = null)
    {
        // validation for constraint: int
        if (!is_null($to) && !is_numeric($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get DateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param string $dateFrom
     * @return \StructType\JP_Rule
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateFrom)), __LINE__);
        }
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateFromHour value
     * @return string|null
     */
    public function getDateFromHour()
    {
        return $this->DateFromHour;
    }
    /**
     * Set DateFromHour value
     * @param string $dateFromHour
     * @return \StructType\JP_Rule
     */
    public function setDateFromHour($dateFromHour = null)
    {
        // validation for constraint: string
        if (!is_null($dateFromHour) && !is_string($dateFromHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateFromHour)), __LINE__);
        }
        $this->DateFromHour = $dateFromHour;
        return $this;
    }
    /**
     * Get DateTo value
     * @return string|null
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param string $dateTo
     * @return \StructType\JP_Rule
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTo)), __LINE__);
        }
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get DateToHour value
     * @return string|null
     */
    public function getDateToHour()
    {
        return $this->DateToHour;
    }
    /**
     * Set DateToHour value
     * @param string $dateToHour
     * @return \StructType\JP_Rule
     */
    public function setDateToHour($dateToHour = null)
    {
        // validation for constraint: string
        if (!is_null($dateToHour) && !is_string($dateToHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateToHour)), __LINE__);
        }
        $this->DateToHour = $dateToHour;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_Rule
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get FixedPrice value
     * @return float|null
     */
    public function getFixedPrice()
    {
        return $this->FixedPrice;
    }
    /**
     * Set FixedPrice value
     * @param float $fixedPrice
     * @return \StructType\JP_Rule
     */
    public function setFixedPrice($fixedPrice = null)
    {
        $this->FixedPrice = $fixedPrice;
        return $this;
    }
    /**
     * Get PercentPrice value
     * @return float|null
     */
    public function getPercentPrice()
    {
        return $this->PercentPrice;
    }
    /**
     * Set PercentPrice value
     * @param float $percentPrice
     * @return \StructType\JP_Rule
     */
    public function setPercentPrice($percentPrice = null)
    {
        $this->PercentPrice = $percentPrice;
        return $this;
    }
    /**
     * Get FirstNightPrice value
     * @return float|null
     */
    public function getFirstNightPrice()
    {
        return $this->FirstNightPrice;
    }
    /**
     * Set FirstNightPrice value
     * @param float $firstNightPrice
     * @return \StructType\JP_Rule
     */
    public function setFirstNightPrice($firstNightPrice = null)
    {
        $this->FirstNightPrice = $firstNightPrice;
        return $this;
    }
    /**
     * Get Nights value
     * @return int|null
     */
    public function getNights()
    {
        return $this->Nights;
    }
    /**
     * Set Nights value
     * @param int $nights
     * @return \StructType\JP_Rule
     */
    public function setNights($nights = null)
    {
        // validation for constraint: int
        if (!is_null($nights) && !is_numeric($nights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nights)), __LINE__);
        }
        $this->Nights = $nights;
        return $this;
    }
    /**
     * Get StayLengthFrom value
     * @return int|null
     */
    public function getStayLengthFrom()
    {
        return $this->StayLengthFrom;
    }
    /**
     * Set StayLengthFrom value
     * @param int $stayLengthFrom
     * @return \StructType\JP_Rule
     */
    public function setStayLengthFrom($stayLengthFrom = null)
    {
        // validation for constraint: int
        if (!is_null($stayLengthFrom) && !is_numeric($stayLengthFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stayLengthFrom)), __LINE__);
        }
        $this->StayLengthFrom = $stayLengthFrom;
        return $this;
    }
    /**
     * Get StayLengthTo value
     * @return int|null
     */
    public function getStayLengthTo()
    {
        return $this->StayLengthTo;
    }
    /**
     * Set StayLengthTo value
     * @param int $stayLengthTo
     * @return \StructType\JP_Rule
     */
    public function setStayLengthTo($stayLengthTo = null)
    {
        // validation for constraint: int
        if (!is_null($stayLengthTo) && !is_numeric($stayLengthTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stayLengthTo)), __LINE__);
        }
        $this->StayLengthTo = $stayLengthTo;
        return $this;
    }
    /**
     * Get ApplicationTypeNights value
     * @return string|null
     */
    public function getApplicationTypeNights()
    {
        return $this->ApplicationTypeNights;
    }
    /**
     * Set ApplicationTypeNights value
     * @param string $applicationTypeNights
     * @return \StructType\JP_Rule
     */
    public function setApplicationTypeNights($applicationTypeNights = null)
    {
        // validation for constraint: string
        if (!is_null($applicationTypeNights) && !is_string($applicationTypeNights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationTypeNights)), __LINE__);
        }
        $this->ApplicationTypeNights = $applicationTypeNights;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Rule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
