<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RestrictedOptions StructType
 * @subpackage Structs
 */
class JP_RestrictedOptions extends AbstractStructBase
{
    /**
     * The RestrictedOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JP_RestrictedOption[]
     */
    public $RestrictedOption;
    /**
     * The Context
     * @var string
     */
    public $Context;
    /**
     * Constructor method for JP_RestrictedOptions
     * @uses JP_RestrictedOptions::setRestrictedOption()
     * @uses JP_RestrictedOptions::setContext()
     * @param \StructType\JP_RestrictedOption[] $restrictedOption
     * @param string $context
     */
    public function __construct(array $restrictedOption = array(), $context = null)
    {
        $this
            ->setRestrictedOption($restrictedOption)
            ->setContext($context);
    }
    /**
     * Get RestrictedOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JP_RestrictedOption[]|null
     */
    public function getRestrictedOption()
    {
        return isset($this->RestrictedOption) ? $this->RestrictedOption : null;
    }
    /**
     * Set RestrictedOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RestrictedOption[] $restrictedOption
     * @return \StructType\JP_RestrictedOptions
     */
    public function setRestrictedOption(array $restrictedOption = array())
    {
        foreach ($restrictedOption as $jP_RestrictedOptionsRestrictedOptionItem) {
            // validation for constraint: itemType
            if (!$jP_RestrictedOptionsRestrictedOptionItem instanceof \StructType\JP_RestrictedOption) {
                throw new \InvalidArgumentException(sprintf('The RestrictedOption property can only contain items of \StructType\JP_RestrictedOption, "%s" given', is_object($jP_RestrictedOptionsRestrictedOptionItem) ? get_class($jP_RestrictedOptionsRestrictedOptionItem) : gettype($jP_RestrictedOptionsRestrictedOptionItem)), __LINE__);
            }
        }
        if (is_null($restrictedOption) || (is_array($restrictedOption) && empty($restrictedOption))) {
            unset($this->RestrictedOption);
        } else {
            $this->RestrictedOption = $restrictedOption;
        }
        return $this;
    }
    /**
     * Add item to RestrictedOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RestrictedOption $item
     * @return \StructType\JP_RestrictedOptions
     */
    public function addToRestrictedOption(\StructType\JP_RestrictedOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RestrictedOption) {
            throw new \InvalidArgumentException(sprintf('The RestrictedOption property can only contain items of \StructType\JP_RestrictedOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RestrictedOption[] = $item;
        return $this;
    }
    /**
     * Get Context value
     * @return string|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @param string $context
     * @return \StructType\JP_RestrictedOptions
     */
    public function setContext($context = null)
    {
        // validation for constraint: string
        if (!is_null($context) && !is_string($context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($context)), __LINE__);
        }
        $this->Context = $context;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RestrictedOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
