<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelOptionBookingRules StructType
 * @subpackage Structs
 */
class JP_HotelOptionBookingRules extends AbstractStructBase
{
    /**
     * The BookingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The HotelRequiredFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelRequiredFields
     */
    public $HotelRequiredFields;
    /**
     * The VirtualCreditCardInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_VirtualCreditCardInfo
     */
    public $VirtualCreditCardInfo;
    /**
     * The CancellationPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The PriceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelOptionCheckAvail
     */
    public $PriceInformation;
    /**
     * The OptionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelOptionalElements
     */
    public $OptionalElements;
    /**
     * The PaymentDestination
     * @var bool
     */
    public $PaymentDestination;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_HotelOptionBookingRules
     * @uses JP_HotelOptionBookingRules::setBookingCode()
     * @uses JP_HotelOptionBookingRules::setHotelRequiredFields()
     * @uses JP_HotelOptionBookingRules::setVirtualCreditCardInfo()
     * @uses JP_HotelOptionBookingRules::setCancellationPolicy()
     * @uses JP_HotelOptionBookingRules::setCancellationPolicyCost()
     * @uses JP_HotelOptionBookingRules::setPriceInformation()
     * @uses JP_HotelOptionBookingRules::setOptionalElements()
     * @uses JP_HotelOptionBookingRules::setPaymentDestination()
     * @uses JP_HotelOptionBookingRules::setStatus()
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_HotelRequiredFields $hotelRequiredFields
     * @param \StructType\JP_VirtualCreditCardInfo $virtualCreditCardInfo
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \StructType\JP_HotelOptionCheckAvail $priceInformation
     * @param \StructType\JP_HotelOptionalElements $optionalElements
     * @param bool $paymentDestination
     * @param string $status
     */
    public function __construct(\StructType\JP_BookingCode $bookingCode = null, \StructType\JP_HotelRequiredFields $hotelRequiredFields = null, \StructType\JP_VirtualCreditCardInfo $virtualCreditCardInfo = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \StructType\JP_HotelOptionCheckAvail $priceInformation = null, \StructType\JP_HotelOptionalElements $optionalElements = null, $paymentDestination = null, $status = null)
    {
        $this
            ->setBookingCode($bookingCode)
            ->setHotelRequiredFields($hotelRequiredFields)
            ->setVirtualCreditCardInfo($virtualCreditCardInfo)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setPriceInformation($priceInformation)
            ->setOptionalElements($optionalElements)
            ->setPaymentDestination($paymentDestination)
            ->setStatus($status);
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get HotelRequiredFields value
     * @return \StructType\JP_HotelRequiredFields|null
     */
    public function getHotelRequiredFields()
    {
        return $this->HotelRequiredFields;
    }
    /**
     * Set HotelRequiredFields value
     * @param \StructType\JP_HotelRequiredFields $hotelRequiredFields
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setHotelRequiredFields(\StructType\JP_HotelRequiredFields $hotelRequiredFields = null)
    {
        $this->HotelRequiredFields = $hotelRequiredFields;
        return $this;
    }
    /**
     * Get VirtualCreditCardInfo value
     * @return \StructType\JP_VirtualCreditCardInfo|null
     */
    public function getVirtualCreditCardInfo()
    {
        return $this->VirtualCreditCardInfo;
    }
    /**
     * Set VirtualCreditCardInfo value
     * @param \StructType\JP_VirtualCreditCardInfo $virtualCreditCardInfo
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setVirtualCreditCardInfo(\StructType\JP_VirtualCreditCardInfo $virtualCreditCardInfo = null)
    {
        $this->VirtualCreditCardInfo = $virtualCreditCardInfo;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_HotelOptionCheckAvail|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_HotelOptionCheckAvail $priceInformation
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setPriceInformation(\StructType\JP_HotelOptionCheckAvail $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_HotelOptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_HotelOptionalElements $optionalElements
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setOptionalElements(\StructType\JP_HotelOptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get PaymentDestination value
     * @return bool|null
     */
    public function getPaymentDestination()
    {
        return $this->PaymentDestination;
    }
    /**
     * Set PaymentDestination value
     * @param bool $paymentDestination
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setPaymentDestination($paymentDestination = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentDestination) && !is_bool($paymentDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($paymentDestination)), __LINE__);
        }
        $this->PaymentDestination = $paymentDestination;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelOptionBookingRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
