<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FinalCustomerSave StructType
 * @subpackage Structs
 */
class JP_FinalCustomerSave extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The FinalCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_FinalCustomerData[]
     */
    public $FinalCustomer;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for JP_FinalCustomerSave
     * @uses JP_FinalCustomerSave::setLogin()
     * @uses JP_FinalCustomerSave::setFinalCustomer()
     * @uses JP_FinalCustomerSave::setRestrictedOptions()
     * @uses JP_FinalCustomerSave::setVersion()
     * @uses JP_FinalCustomerSave::setLanguage()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_FinalCustomerData[] $finalCustomer
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     */
    public function __construct(\StructType\JP_Login $login = null, array $finalCustomer = array(), \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null)
    {
        $this
            ->setLogin($login)
            ->setFinalCustomer($finalCustomer)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_FinalCustomerSave
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get FinalCustomer value
     * @return \StructType\JP_FinalCustomerData[]|null
     */
    public function getFinalCustomer()
    {
        return $this->FinalCustomer;
    }
    /**
     * Set FinalCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FinalCustomerData[] $finalCustomer
     * @return \StructType\JP_FinalCustomerSave
     */
    public function setFinalCustomer(array $finalCustomer = array())
    {
        foreach ($finalCustomer as $jP_FinalCustomerSaveFinalCustomerItem) {
            // validation for constraint: itemType
            if (!$jP_FinalCustomerSaveFinalCustomerItem instanceof \StructType\JP_FinalCustomerData) {
                throw new \InvalidArgumentException(sprintf('The FinalCustomer property can only contain items of \StructType\JP_FinalCustomerData, "%s" given', is_object($jP_FinalCustomerSaveFinalCustomerItem) ? get_class($jP_FinalCustomerSaveFinalCustomerItem) : gettype($jP_FinalCustomerSaveFinalCustomerItem)), __LINE__);
            }
        }
        $this->FinalCustomer = $finalCustomer;
        return $this;
    }
    /**
     * Add item to FinalCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FinalCustomerData $item
     * @return \StructType\JP_FinalCustomerSave
     */
    public function addToFinalCustomer(\StructType\JP_FinalCustomerData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_FinalCustomerData) {
            throw new \InvalidArgumentException(sprintf('The FinalCustomer property can only contain items of \StructType\JP_FinalCustomerData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FinalCustomer[] = $item;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_FinalCustomerSave
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_FinalCustomerSave
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_FinalCustomerSave
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FinalCustomerSave
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
