<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_hotelRatePlanCancellationPolicyRule StructType
 * @subpackage Structs
 */
class JPSOAP_hotelRatePlanCancellationPolicyRule extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The ApplicationTypeNights
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ApplicationTypeNights;
    /**
     * The From
     * @var int
     */
    public $From;
    /**
     * The To
     * @var int
     */
    public $To;
    /**
     * The StayLengthFrom
     * @var int
     */
    public $StayLengthFrom;
    /**
     * The StayLengthTo
     * @var int
     */
    public $StayLengthTo;
    /**
     * The FixedPrice
     * @var float
     */
    public $FixedPrice;
    /**
     * The PercentPrice
     * @var float
     */
    public $PercentPrice;
    /**
     * The Nights
     * @var int
     */
    public $Nights;
    /**
     * Constructor method for JPSOAP_hotelRatePlanCancellationPolicyRule
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setType()
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setApplicationTypeNights()
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setFrom()
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setTo()
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setStayLengthFrom()
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setStayLengthTo()
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setFixedPrice()
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setPercentPrice()
     * @uses JPSOAP_hotelRatePlanCancellationPolicyRule::setNights()
     * @param string $type
     * @param string $applicationTypeNights
     * @param int $from
     * @param int $to
     * @param int $stayLengthFrom
     * @param int $stayLengthTo
     * @param float $fixedPrice
     * @param float $percentPrice
     * @param int $nights
     */
    public function __construct($type = null, $applicationTypeNights = null, $from = null, $to = null, $stayLengthFrom = null, $stayLengthTo = null, $fixedPrice = null, $percentPrice = null, $nights = null)
    {
        $this
            ->setType($type)
            ->setApplicationTypeNights($applicationTypeNights)
            ->setFrom($from)
            ->setTo($to)
            ->setStayLengthFrom($stayLengthFrom)
            ->setStayLengthTo($stayLengthTo)
            ->setFixedPrice($fixedPrice)
            ->setPercentPrice($percentPrice)
            ->setNights($nights);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JPSOAP_CancellationPolicyRuleTypes::valueIsValid()
     * @uses \EnumType\JPSOAP_CancellationPolicyRuleTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_CancellationPolicyRuleTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\JPSOAP_CancellationPolicyRuleTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ApplicationTypeNights value
     * @return string
     */
    public function getApplicationTypeNights()
    {
        return $this->ApplicationTypeNights;
    }
    /**
     * Set ApplicationTypeNights value
     * @uses \EnumType\JPSOAP_CancellationPolicyRuleQuotationType::valueIsValid()
     * @uses \EnumType\JPSOAP_CancellationPolicyRuleQuotationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationTypeNights
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setApplicationTypeNights($applicationTypeNights = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_CancellationPolicyRuleQuotationType::valueIsValid($applicationTypeNights)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $applicationTypeNights, implode(', ', \EnumType\JPSOAP_CancellationPolicyRuleQuotationType::getValidValues())), __LINE__);
        }
        $this->ApplicationTypeNights = $applicationTypeNights;
        return $this;
    }
    /**
     * Get From value
     * @return int|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param int $from
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setFrom($from = null)
    {
        // validation for constraint: int
        if (!is_null($from) && !is_numeric($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return int|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param int $to
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setTo($to = null)
    {
        // validation for constraint: int
        if (!is_null($to) && !is_numeric($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get StayLengthFrom value
     * @return int|null
     */
    public function getStayLengthFrom()
    {
        return $this->StayLengthFrom;
    }
    /**
     * Set StayLengthFrom value
     * @param int $stayLengthFrom
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setStayLengthFrom($stayLengthFrom = null)
    {
        // validation for constraint: int
        if (!is_null($stayLengthFrom) && !is_numeric($stayLengthFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stayLengthFrom)), __LINE__);
        }
        $this->StayLengthFrom = $stayLengthFrom;
        return $this;
    }
    /**
     * Get StayLengthTo value
     * @return int|null
     */
    public function getStayLengthTo()
    {
        return $this->StayLengthTo;
    }
    /**
     * Set StayLengthTo value
     * @param int $stayLengthTo
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setStayLengthTo($stayLengthTo = null)
    {
        // validation for constraint: int
        if (!is_null($stayLengthTo) && !is_numeric($stayLengthTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stayLengthTo)), __LINE__);
        }
        $this->StayLengthTo = $stayLengthTo;
        return $this;
    }
    /**
     * Get FixedPrice value
     * @return float|null
     */
    public function getFixedPrice()
    {
        return $this->FixedPrice;
    }
    /**
     * Set FixedPrice value
     * @param float $fixedPrice
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setFixedPrice($fixedPrice = null)
    {
        $this->FixedPrice = $fixedPrice;
        return $this;
    }
    /**
     * Get PercentPrice value
     * @return float|null
     */
    public function getPercentPrice()
    {
        return $this->PercentPrice;
    }
    /**
     * Set PercentPrice value
     * @param float $percentPrice
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setPercentPrice($percentPrice = null)
    {
        $this->PercentPrice = $percentPrice;
        return $this;
    }
    /**
     * Get Nights value
     * @return int|null
     */
    public function getNights()
    {
        return $this->Nights;
    }
    /**
     * Set Nights value
     * @param int $nights
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public function setNights($nights = null)
    {
        // validation for constraint: int
        if (!is_null($nights) && !is_numeric($nights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nights)), __LINE__);
        }
        $this->Nights = $nights;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_hotelRatePlanCancellationPolicyRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
