<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_Occupancies StructType
 * @subpackage Structs
 */
class JPSOAP_Occupancies extends AbstractStructBase
{
    /**
     * The Occupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_Occupancy[]
     */
    public $Occupancy;
    /**
     * Constructor method for JPSOAP_Occupancies
     * @uses JPSOAP_Occupancies::setOccupancy()
     * @param \StructType\JPSOAP_Occupancy[] $occupancy
     */
    public function __construct(array $occupancy = array())
    {
        $this
            ->setOccupancy($occupancy);
    }
    /**
     * Get Occupancy value
     * @return \StructType\JPSOAP_Occupancy[]|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_Occupancy[] $occupancy
     * @return \StructType\JPSOAP_Occupancies
     */
    public function setOccupancy(array $occupancy = array())
    {
        foreach ($occupancy as $jPSOAP_OccupanciesOccupancyItem) {
            // validation for constraint: itemType
            if (!$jPSOAP_OccupanciesOccupancyItem instanceof \StructType\JPSOAP_Occupancy) {
                throw new \InvalidArgumentException(sprintf('The Occupancy property can only contain items of \StructType\JPSOAP_Occupancy, "%s" given', is_object($jPSOAP_OccupanciesOccupancyItem) ? get_class($jPSOAP_OccupanciesOccupancyItem) : gettype($jPSOAP_OccupanciesOccupancyItem)), __LINE__);
            }
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Add item to Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_Occupancy $item
     * @return \StructType\JPSOAP_Occupancies
     */
    public function addToOccupancy(\StructType\JPSOAP_Occupancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_Occupancy) {
            throw new \InvalidArgumentException(sprintf('The Occupancy property can only contain items of \StructType\JPSOAP_Occupancy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Occupancy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_Occupancies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
