<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString4 extends AbstractStructArrayBase
{
    /**
     * The PackageCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PackageCode;
    /**
     * Constructor method for ArrayOfString4
     * @uses ArrayOfString4::setPackageCode()
     * @param string[] $packageCode
     */
    public function __construct(array $packageCode = array())
    {
        $this
            ->setPackageCode($packageCode);
    }
    /**
     * Get PackageCode value
     * @return string[]|null
     */
    public function getPackageCode()
    {
        return $this->PackageCode;
    }
    /**
     * Set PackageCode value
     * @throws \InvalidArgumentException
     * @param string[] $packageCode
     * @return \ArrayType\ArrayOfString4
     */
    public function setPackageCode(array $packageCode = array())
    {
        foreach ($packageCode as $arrayOfString4PackageCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString4PackageCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The PackageCode property can only contain items of string, "%s" given', is_object($arrayOfString4PackageCodeItem) ? get_class($arrayOfString4PackageCodeItem) : gettype($arrayOfString4PackageCodeItem)), __LINE__);
            }
        }
        $this->PackageCode = $packageCode;
        return $this;
    }
    /**
     * Add item to PackageCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString4
     */
    public function addToPackageCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PackageCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PackageCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PackageCode
     */
    public function getAttributeName()
    {
        return 'PackageCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
