<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarPriceInformation StructType
 * @subpackage Structs
 */
class JP_RentacarPriceInformation extends AbstractStructBase
{
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The SaleContractName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SaleContractName;
    /**
     * The CostContractName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostContractName;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarAdditionalElements
     */
    public $AdditionalElements;
    /**
     * Constructor method for JP_RentacarPriceInformation
     * @uses JP_RentacarPriceInformation::setPrices()
     * @uses JP_RentacarPriceInformation::setSaleContractName()
     * @uses JP_RentacarPriceInformation::setCostContractName()
     * @uses JP_RentacarPriceInformation::setAdditionalElements()
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $saleContractName
     * @param string $costContractName
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     */
    public function __construct(\ArrayType\ArrayOfJP_Price $prices = null, $saleContractName = null, $costContractName = null, \StructType\JP_RentacarAdditionalElements $additionalElements = null)
    {
        $this
            ->setPrices($prices)
            ->setSaleContractName($saleContractName)
            ->setCostContractName($costContractName)
            ->setAdditionalElements($additionalElements);
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get SaleContractName value
     * @return string|null
     */
    public function getSaleContractName()
    {
        return $this->SaleContractName;
    }
    /**
     * Set SaleContractName value
     * @param string $saleContractName
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setSaleContractName($saleContractName = null)
    {
        // validation for constraint: string
        if (!is_null($saleContractName) && !is_string($saleContractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleContractName, true), gettype($saleContractName)), __LINE__);
        }
        $this->SaleContractName = $saleContractName;
        return $this;
    }
    /**
     * Get CostContractName value
     * @return string|null
     */
    public function getCostContractName()
    {
        return $this->CostContractName;
    }
    /**
     * Set CostContractName value
     * @param string $costContractName
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setCostContractName($costContractName = null)
    {
        // validation for constraint: string
        if (!is_null($costContractName) && !is_string($costContractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costContractName, true), gettype($costContractName)), __LINE__);
        }
        $this->CostContractName = $costContractName;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_RentacarAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setAdditionalElements(\StructType\JP_RentacarAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RentacarPriceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
