<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelDailyContract StructType
 * @subpackage Structs
 */
class JP_HotelDailyContract extends JP_HotelContractType
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Days
     * @var int
     */
    public $Days;
    /**
     * The ExtranetContract
     * @var bool
     */
    public $ExtranetContract;
    /**
     * Constructor method for JP_HotelDailyContract
     * @uses JP_HotelDailyContract::setCode()
     * @uses JP_HotelDailyContract::setStart()
     * @uses JP_HotelDailyContract::setDays()
     * @uses JP_HotelDailyContract::setExtranetContract()
     * @param string $code
     * @param string $start
     * @param int $days
     * @param bool $extranetContract
     */
    public function __construct($code = null, $start = null, $days = null, $extranetContract = null)
    {
        $this
            ->setCode($code)
            ->setStart($start)
            ->setDays($days)
            ->setExtranetContract($extranetContract);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_HotelDailyContract
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_HotelDailyContract
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Days value
     * @return int|null
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \StructType\JP_HotelDailyContract
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !(is_int($days) || ctype_digit($days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($days, true), gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get ExtranetContract value
     * @return bool|null
     */
    public function getExtranetContract()
    {
        return $this->ExtranetContract;
    }
    /**
     * Set ExtranetContract value
     * @param bool $extranetContract
     * @return \StructType\JP_HotelDailyContract
     */
    public function setExtranetContract($extranetContract = null)
    {
        // validation for constraint: boolean
        if (!is_null($extranetContract) && !is_bool($extranetContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extranetContract, true), gettype($extranetContract)), __LINE__);
        }
        $this->ExtranetContract = $extranetContract;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelDailyContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
