<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Final ServiceType
 * @subpackage Services
 */
class _Final extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FinalCustomerSave
     * Meta information extracted from the WSDL
     * - documentation: Save final customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FinalCustomerSave $parameters
     * @return \StructType\FinalCustomerSaveResponse|bool
     */
    public function FinalCustomerSave(\StructType\FinalCustomerSave $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FinalCustomerSave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FinalCustomerRead
     * Meta information extracted from the WSDL
     * - documentation: Generic Final Customer List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FinalCustomerRead $parameters
     * @return \StructType\FinalCustomerReadResponse|bool
     */
    public function FinalCustomerRead(\StructType\FinalCustomerRead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FinalCustomerRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FinalCustomerReadResponse|\StructType\FinalCustomerSaveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
