<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceOption StructType
 * @subpackage Structs
 */
class JP_ServiceOption extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The OccupancyAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Ocuppancy
     */
    public $OccupancyAllowed;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The DestinationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationName;
    /**
     * The Dates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceDate
     */
    public $Dates;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The RestrictedMeetingPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_MeetingPoint
     */
    public $RestrictedMeetingPoints;
    /**
     * The Languages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Language
     */
    public $Languages;
    /**
     * The ServiceBookingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceBookingInfo
     */
    public $ServiceBookingInfo;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Destination
     * @var int
     */
    public $Destination;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The NumberOfDays
     * @var int
     */
    public $NumberOfDays;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * Constructor method for JP_ServiceOption
     * @uses JP_ServiceOption::setName()
     * @uses JP_ServiceOption::setOccupancyAllowed()
     * @uses JP_ServiceOption::setDescription()
     * @uses JP_ServiceOption::setImages()
     * @uses JP_ServiceOption::setDestinationName()
     * @uses JP_ServiceOption::setDates()
     * @uses JP_ServiceOption::setAdditionalElements()
     * @uses JP_ServiceOption::setRestrictedMeetingPoints()
     * @uses JP_ServiceOption::setLanguages()
     * @uses JP_ServiceOption::setServiceBookingInfo()
     * @uses JP_ServiceOption::setCode()
     * @uses JP_ServiceOption::setStart()
     * @uses JP_ServiceOption::setEnd()
     * @uses JP_ServiceOption::setDestination()
     * @uses JP_ServiceOption::setDuration()
     * @uses JP_ServiceOption::setOrder()
     * @uses JP_ServiceOption::setNumberOfDays()
     * @uses JP_ServiceOption::setStartTime()
     * @param string $name
     * @param \StructType\JP_Ocuppancy $occupancyAllowed
     * @param string $description
     * @param \ArrayType\ArrayOfString1 $images
     * @param string $destinationName
     * @param \ArrayType\ArrayOfJP_ServiceDate $dates
     * @param \StructType\JP_ServiceAdditionalElements $additionalElements
     * @param \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints
     * @param \ArrayType\ArrayOfJP_Language $languages
     * @param \StructType\JP_ServiceBookingInfo $serviceBookingInfo
     * @param string $code
     * @param string $start
     * @param string $end
     * @param int $destination
     * @param string $duration
     * @param int $order
     * @param int $numberOfDays
     * @param string $startTime
     */
    public function __construct($name = null, \StructType\JP_Ocuppancy $occupancyAllowed = null, $description = null, \ArrayType\ArrayOfString1 $images = null, $destinationName = null, \ArrayType\ArrayOfJP_ServiceDate $dates = null, \StructType\JP_ServiceAdditionalElements $additionalElements = null, \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints = null, \ArrayType\ArrayOfJP_Language $languages = null, \StructType\JP_ServiceBookingInfo $serviceBookingInfo = null, $code = null, $start = null, $end = null, $destination = null, $duration = null, $order = null, $numberOfDays = null, $startTime = null)
    {
        $this
            ->setName($name)
            ->setOccupancyAllowed($occupancyAllowed)
            ->setDescription($description)
            ->setImages($images)
            ->setDestinationName($destinationName)
            ->setDates($dates)
            ->setAdditionalElements($additionalElements)
            ->setRestrictedMeetingPoints($restrictedMeetingPoints)
            ->setLanguages($languages)
            ->setServiceBookingInfo($serviceBookingInfo)
            ->setCode($code)
            ->setStart($start)
            ->setEnd($end)
            ->setDestination($destination)
            ->setDuration($duration)
            ->setOrder($order)
            ->setNumberOfDays($numberOfDays)
            ->setStartTime($startTime);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceOption
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get OccupancyAllowed value
     * @return \StructType\JP_Ocuppancy|null
     */
    public function getOccupancyAllowed()
    {
        return $this->OccupancyAllowed;
    }
    /**
     * Set OccupancyAllowed value
     * @param \StructType\JP_Ocuppancy $occupancyAllowed
     * @return \StructType\JP_ServiceOption
     */
    public function setOccupancyAllowed(\StructType\JP_Ocuppancy $occupancyAllowed = null)
    {
        $this->OccupancyAllowed = $occupancyAllowed;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_ServiceOption
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_ServiceOption
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return string|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param string $destinationName
     * @return \StructType\JP_ServiceOption
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get Dates value
     * @return \ArrayType\ArrayOfJP_ServiceDate|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @param \ArrayType\ArrayOfJP_ServiceDate $dates
     * @return \StructType\JP_ServiceOption
     */
    public function setDates(\ArrayType\ArrayOfJP_ServiceDate $dates = null)
    {
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_ServiceAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_ServiceAdditionalElements $additionalElements
     * @return \StructType\JP_ServiceOption
     */
    public function setAdditionalElements(\StructType\JP_ServiceAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get RestrictedMeetingPoints value
     * @return \ArrayType\ArrayOfJP_MeetingPoint|null
     */
    public function getRestrictedMeetingPoints()
    {
        return $this->RestrictedMeetingPoints;
    }
    /**
     * Set RestrictedMeetingPoints value
     * @param \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints
     * @return \StructType\JP_ServiceOption
     */
    public function setRestrictedMeetingPoints(\ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints = null)
    {
        $this->RestrictedMeetingPoints = $restrictedMeetingPoints;
        return $this;
    }
    /**
     * Get Languages value
     * @return \ArrayType\ArrayOfJP_Language|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \ArrayType\ArrayOfJP_Language $languages
     * @return \StructType\JP_ServiceOption
     */
    public function setLanguages(\ArrayType\ArrayOfJP_Language $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Get ServiceBookingInfo value
     * @return \StructType\JP_ServiceBookingInfo|null
     */
    public function getServiceBookingInfo()
    {
        return $this->ServiceBookingInfo;
    }
    /**
     * Set ServiceBookingInfo value
     * @param \StructType\JP_ServiceBookingInfo $serviceBookingInfo
     * @return \StructType\JP_ServiceOption
     */
    public function setServiceBookingInfo(\StructType\JP_ServiceBookingInfo $serviceBookingInfo = null)
    {
        $this->ServiceBookingInfo = $serviceBookingInfo;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ServiceOption
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_ServiceOption
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_ServiceOption
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Destination value
     * @return int|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param int $destination
     * @return \StructType\JP_ServiceOption
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: int
        if (!is_null($destination) && !(is_int($destination) || ctype_digit($destination))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\JP_ServiceOption
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_ServiceOption
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get NumberOfDays value
     * @return int|null
     */
    public function getNumberOfDays()
    {
        return $this->NumberOfDays;
    }
    /**
     * Set NumberOfDays value
     * @param int $numberOfDays
     * @return \StructType\JP_ServiceOption
     */
    public function setNumberOfDays($numberOfDays = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDays) && !(is_int($numberOfDays) || ctype_digit($numberOfDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDays, true), gettype($numberOfDays)), __LINE__);
        }
        $this->NumberOfDays = $numberOfDays;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\JP_ServiceOption
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
