<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelListInventoryRQ StructType
 * @subpackage Structs
 */
class JP_HotelListInventoryRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The HotelListInventoryRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelListInventoryRequest
     */
    public $HotelListInventoryRequest;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for JP_HotelListInventoryRQ
     * @uses JP_HotelListInventoryRQ::setLogin()
     * @uses JP_HotelListInventoryRQ::setHotelListInventoryRequest()
     * @uses JP_HotelListInventoryRQ::setRestrictedOptions()
     * @uses JP_HotelListInventoryRQ::setVersion()
     * @uses JP_HotelListInventoryRQ::setLanguage()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_HotelListInventoryRequest $hotelListInventoryRequest
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_HotelListInventoryRequest $hotelListInventoryRequest = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null)
    {
        $this
            ->setLogin($login)
            ->setHotelListInventoryRequest($hotelListInventoryRequest)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_HotelListInventoryRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get HotelListInventoryRequest value
     * @return \StructType\JP_HotelListInventoryRequest|null
     */
    public function getHotelListInventoryRequest()
    {
        return $this->HotelListInventoryRequest;
    }
    /**
     * Set HotelListInventoryRequest value
     * @param \StructType\JP_HotelListInventoryRequest $hotelListInventoryRequest
     * @return \StructType\JP_HotelListInventoryRQ
     */
    public function setHotelListInventoryRequest(\StructType\JP_HotelListInventoryRequest $hotelListInventoryRequest = null)
    {
        $this->HotelListInventoryRequest = $hotelListInventoryRequest;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_HotelListInventoryRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_HotelListInventoryRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_HotelListInventoryRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelListInventoryRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
