<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Service ServiceType
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ServiceBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for services.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceBooking $parameters
     * @return \StructType\ServiceBookingResponse|bool
     */
    public function ServiceBooking(\StructType\ServiceBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServiceBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServiceModify
     * Meta information extracted from the WSDL
     * - documentation: Modify for services
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceModify $parameters
     * @return \StructType\ServiceModifyResponse|bool
     */
    public function ServiceModify(\StructType\ServiceModify $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServiceModify($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServiceConfirmModify
     * Meta information extracted from the WSDL
     * - documentation: ConfirmModify for Services
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceConfirmModify $parameters
     * @return \StructType\ServiceConfirmModifyResponse|bool
     */
    public function ServiceConfirmModify(\StructType\ServiceConfirmModify $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServiceConfirmModify($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServiceAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for services.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceAvail $parameters
     * @return \StructType\ServiceAvailResponse|bool
     */
    public function ServiceAvail(\StructType\ServiceAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServiceAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServiceCatalogueData
     * Meta information extracted from the WSDL
     * - documentation: Catalogue For Services
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceCatalogueData $parameters
     * @return \StructType\ServiceCatalogueDataResponse|bool
     */
    public function ServiceCatalogueData(\StructType\ServiceCatalogueData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServiceCatalogueData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServicePortfolio
     * Meta information extracted from the WSDL
     * - documentation: Paged Portfolio of Services
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServicePortfolio $parameters
     * @return \StructType\ServicePortfolioResponse|bool
     */
    public function ServicePortfolio(\StructType\ServicePortfolio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServicePortfolio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServiceContent
     * Meta information extracted from the WSDL
     * - documentation: Content Of Services
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceContent $parameters
     * @return \StructType\ServiceContentResponse|bool
     */
    public function ServiceContent(\StructType\ServiceContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServiceContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServiceCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for services and tickets.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceCheckAvail $parameters
     * @return \StructType\ServiceCheckAvailResponse|bool
     */
    public function ServiceCheckAvail(\StructType\ServiceCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServiceCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServiceBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules Of services
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceBookingRules $parameters
     * @return \StructType\ServiceBookingRulesResponse|bool
     */
    public function ServiceBookingRules(\StructType\ServiceBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ServiceBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ServiceAvailResponse|\StructType\ServiceBookingResponse|\StructType\ServiceBookingRulesResponse|\StructType\ServiceCatalogueDataResponse|\StructType\ServiceCheckAvailResponse|\StructType\ServiceConfirmModifyResponse|\StructType\ServiceContentResponse|\StructType\ServiceModifyResponse|\StructType\ServicePortfolioResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
