<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_TaxTypes EnumType
 * @subpackage Enumerations
 */
class JPSOAP_TaxTypes
{
    /**
     * Constant for value 'FixedPerPerson'
     * @return string 'FixedPerPerson'
     */
    const VALUE_FIXED_PER_PERSON = 'FixedPerPerson';
    /**
     * Constant for value 'FixedPerPersonPerNight'
     * @return string 'FixedPerPersonPerNight'
     */
    const VALUE_FIXED_PER_PERSON_PER_NIGHT = 'FixedPerPersonPerNight';
    /**
     * Constant for value 'FixedPerRoom'
     * @return string 'FixedPerRoom'
     */
    const VALUE_FIXED_PER_ROOM = 'FixedPerRoom';
    /**
     * Constant for value 'FixedPerRoomPerNight'
     * @return string 'FixedPerRoomPerNight'
     */
    const VALUE_FIXED_PER_ROOM_PER_NIGHT = 'FixedPerRoomPerNight';
    /**
     * Constant for value 'FixedPerBooking'
     * @return string 'FixedPerBooking'
     */
    const VALUE_FIXED_PER_BOOKING = 'FixedPerBooking';
    /**
     * Constant for value 'FixedPerBookingPerNight'
     * @return string 'FixedPerBookingPerNight'
     */
    const VALUE_FIXED_PER_BOOKING_PER_NIGHT = 'FixedPerBookingPerNight';
    /**
     * Constant for value 'Percentage'
     * @return string 'Percentage'
     */
    const VALUE_PERCENTAGE = 'Percentage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIXED_PER_PERSON
     * @uses self::VALUE_FIXED_PER_PERSON_PER_NIGHT
     * @uses self::VALUE_FIXED_PER_ROOM
     * @uses self::VALUE_FIXED_PER_ROOM_PER_NIGHT
     * @uses self::VALUE_FIXED_PER_BOOKING
     * @uses self::VALUE_FIXED_PER_BOOKING_PER_NIGHT
     * @uses self::VALUE_PERCENTAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIXED_PER_PERSON,
            self::VALUE_FIXED_PER_PERSON_PER_NIGHT,
            self::VALUE_FIXED_PER_ROOM,
            self::VALUE_FIXED_PER_ROOM_PER_NIGHT,
            self::VALUE_FIXED_PER_BOOKING,
            self::VALUE_FIXED_PER_BOOKING_PER_NIGHT,
            self::VALUE_PERCENTAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
