<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Suppliers StructType
 * @subpackage Structs
 */
class JP_Suppliers extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Supplier;
    /**
     * The Excluded
     * @var bool
     */
    public $Excluded;
    /**
     * Constructor method for JP_Suppliers
     * @uses JP_Suppliers::setSupplier()
     * @uses JP_Suppliers::setExcluded()
     * @param string[] $supplier
     * @param bool $excluded
     */
    public function __construct(array $supplier = array(), $excluded = null)
    {
        $this
            ->setSupplier($supplier)
            ->setExcluded($excluded);
    }
    /**
     * Get Supplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSupplier()
    {
        return isset($this->Supplier) ? $this->Supplier : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplierForArrayConstraintsFromSetSupplier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_SuppliersSupplierItem) {
            // validation for constraint: itemType
            if (!is_string($jP_SuppliersSupplierItem)) {
                $invalidValues[] = is_object($jP_SuppliersSupplierItem) ? get_class($jP_SuppliersSupplierItem) : sprintf('%s(%s)', gettype($jP_SuppliersSupplierItem), var_export($jP_SuppliersSupplierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $supplier
     * @return \StructType\JP_Suppliers
     */
    public function setSupplier(array $supplier = array())
    {
        // validation for constraint: array
        if ('' !== ($supplierArrayErrorMessage = self::validateSupplierForArrayConstraintsFromSetSupplier($supplier))) {
            throw new \InvalidArgumentException($supplierArrayErrorMessage, __LINE__);
        }
        if (is_null($supplier) || (is_array($supplier) && empty($supplier))) {
            unset($this->Supplier);
        } else {
            $this->Supplier = $supplier;
        }
        return $this;
    }
    /**
     * Add item to Supplier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\JP_Suppliers
     */
    public function addToSupplier($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Supplier property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier[] = $item;
        return $this;
    }
    /**
     * Get Excluded value
     * @return bool|null
     */
    public function getExcluded()
    {
        return $this->Excluded;
    }
    /**
     * Set Excluded value
     * @param bool $excluded
     * @return \StructType\JP_Suppliers
     */
    public function setExcluded($excluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($excluded) && !is_bool($excluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excluded, true), gettype($excluded)), __LINE__);
        }
        $this->Excluded = $excluded;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Suppliers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
