<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceOffer StructType
 * @subpackage Structs
 */
class JP_ServiceOffer extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Code;
    /**
     * The NonRefundable
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $NonRefundable;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Upgrade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceOfferUpgrade
     */
    public $Upgrade;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for JP_ServiceOffer
     * @uses JP_ServiceOffer::setCode()
     * @uses JP_ServiceOffer::setNonRefundable()
     * @uses JP_ServiceOffer::setType()
     * @uses JP_ServiceOffer::setName()
     * @uses JP_ServiceOffer::setDescription()
     * @uses JP_ServiceOffer::setUpgrade()
     * @uses JP_ServiceOffer::setAmount()
     * @param int $code
     * @param bool $nonRefundable
     * @param string $type
     * @param string $name
     * @param string $description
     * @param \StructType\JP_ServiceOfferUpgrade $upgrade
     * @param float $amount
     */
    public function __construct($code = null, $nonRefundable = null, $type = null, $name = null, $description = null, \StructType\JP_ServiceOfferUpgrade $upgrade = null, $amount = null)
    {
        $this
            ->setCode($code)
            ->setNonRefundable($nonRefundable)
            ->setType($type)
            ->setName($name)
            ->setDescription($description)
            ->setUpgrade($upgrade)
            ->setAmount($amount);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_ServiceOffer
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \StructType\JP_ServiceOffer
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundable, true), gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_OffersType::valueIsValid()
     * @uses \EnumType\JP_OffersType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_ServiceOffer
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_OffersType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_OffersType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JP_OffersType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceOffer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_ServiceOffer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Upgrade value
     * @return \StructType\JP_ServiceOfferUpgrade|null
     */
    public function getUpgrade()
    {
        return $this->Upgrade;
    }
    /**
     * Set Upgrade value
     * @param \StructType\JP_ServiceOfferUpgrade $upgrade
     * @return \StructType\JP_ServiceOffer
     */
    public function setUpgrade(\StructType\JP_ServiceOfferUpgrade $upgrade = null)
    {
        $this->Upgrade = $upgrade;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JP_ServiceOffer
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
