<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageItem StructType
 * @subpackage Structs
 */
class JP_PackageItem extends JP_BaseItem
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The PackageInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageInfo
     */
    public $PackageInfo;
    /**
     * The Stays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageStay
     */
    public $Stays;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The RelPaxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPax
     */
    public $RelPaxes;
    /**
     * The AFIPInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageInfoAFIPAmount
     */
    public $AFIPInformation;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_PackageItem
     * @uses JP_PackageItem::setStart()
     * @uses JP_PackageItem::setEnd()
     * @uses JP_PackageItem::setPackageInfo()
     * @uses JP_PackageItem::setStays()
     * @uses JP_PackageItem::setAdditionalElements()
     * @uses JP_PackageItem::setCancellationPolicy()
     * @uses JP_PackageItem::setRelPaxes()
     * @uses JP_PackageItem::setAFIPInformation()
     * @uses JP_PackageItem::setCode()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_PackageInfo $packageInfo
     * @param \ArrayType\ArrayOfJP_PackageStay $stays
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @param \ArrayType\ArrayOfJP_PackageInfoAFIPAmount $aFIPInformation
     * @param string $code
     */
    public function __construct($start = null, $end = null, \StructType\JP_PackageInfo $packageInfo = null, \ArrayType\ArrayOfJP_PackageStay $stays = null, \StructType\JP_PackageAdditionalElements $additionalElements = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \ArrayType\ArrayOfJP_RelPax $relPaxes = null, \ArrayType\ArrayOfJP_PackageInfoAFIPAmount $aFIPInformation = null, $code = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setPackageInfo($packageInfo)
            ->setStays($stays)
            ->setAdditionalElements($additionalElements)
            ->setCancellationPolicy($cancellationPolicy)
            ->setRelPaxes($relPaxes)
            ->setAFIPInformation($aFIPInformation)
            ->setCode($code);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PackageItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PackageItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get PackageInfo value
     * @return \StructType\JP_PackageInfo|null
     */
    public function getPackageInfo()
    {
        return $this->PackageInfo;
    }
    /**
     * Set PackageInfo value
     * @param \StructType\JP_PackageInfo $packageInfo
     * @return \StructType\JP_PackageItem
     */
    public function setPackageInfo(\StructType\JP_PackageInfo $packageInfo = null)
    {
        $this->PackageInfo = $packageInfo;
        return $this;
    }
    /**
     * Get Stays value
     * @return \ArrayType\ArrayOfJP_PackageStay|null
     */
    public function getStays()
    {
        return $this->Stays;
    }
    /**
     * Set Stays value
     * @param \ArrayType\ArrayOfJP_PackageStay $stays
     * @return \StructType\JP_PackageItem
     */
    public function setStays(\ArrayType\ArrayOfJP_PackageStay $stays = null)
    {
        $this->Stays = $stays;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_PackageAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @return \StructType\JP_PackageItem
     */
    public function setAdditionalElements(\StructType\JP_PackageAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_PackageItem
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_RelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @return \StructType\JP_PackageItem
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_RelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get AFIPInformation value
     * @return \ArrayType\ArrayOfJP_PackageInfoAFIPAmount|null
     */
    public function getAFIPInformation()
    {
        return $this->AFIPInformation;
    }
    /**
     * Set AFIPInformation value
     * @param \ArrayType\ArrayOfJP_PackageInfoAFIPAmount $aFIPInformation
     * @return \StructType\JP_PackageItem
     */
    public function setAFIPInformation(\ArrayType\ArrayOfJP_PackageInfoAFIPAmount $aFIPInformation = null)
    {
        $this->AFIPInformation = $aFIPInformation;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
