<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Departments StructType
 * @subpackage Structs
 */
class JP_Departments extends AbstractStructBase
{
    /**
     * The AllowALL
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AllowALL;
    /**
     * The Department
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CustomerIDElement[]
     */
    public $Department;
    /**
     * Constructor method for JP_Departments
     * @uses JP_Departments::setAllowALL()
     * @uses JP_Departments::setDepartment()
     * @param bool $allowALL
     * @param \StructType\JP_CustomerIDElement[] $department
     */
    public function __construct($allowALL = null, array $department = array())
    {
        $this
            ->setAllowALL($allowALL)
            ->setDepartment($department);
    }
    /**
     * Get AllowALL value
     * @return bool
     */
    public function getAllowALL()
    {
        return $this->AllowALL;
    }
    /**
     * Set AllowALL value
     * @param bool $allowALL
     * @return \StructType\JP_Departments
     */
    public function setAllowALL($allowALL = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowALL) && !is_bool($allowALL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowALL, true), gettype($allowALL)), __LINE__);
        }
        $this->AllowALL = $allowALL;
        return $this;
    }
    /**
     * Get Department value
     * @return \StructType\JP_CustomerIDElement[]|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * This method is responsible for validating the values passed to the setDepartment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartmentForArrayConstraintsFromSetDepartment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_DepartmentsDepartmentItem) {
            // validation for constraint: itemType
            if (!$jP_DepartmentsDepartmentItem instanceof \StructType\JP_CustomerIDElement) {
                $invalidValues[] = is_object($jP_DepartmentsDepartmentItem) ? get_class($jP_DepartmentsDepartmentItem) : sprintf('%s(%s)', gettype($jP_DepartmentsDepartmentItem), var_export($jP_DepartmentsDepartmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Department property can only contain items of type \StructType\JP_CustomerIDElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Department value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerIDElement[] $department
     * @return \StructType\JP_Departments
     */
    public function setDepartment(array $department = array())
    {
        // validation for constraint: array
        if ('' !== ($departmentArrayErrorMessage = self::validateDepartmentForArrayConstraintsFromSetDepartment($department))) {
            throw new \InvalidArgumentException($departmentArrayErrorMessage, __LINE__);
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Add item to Department value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerIDElement $item
     * @return \StructType\JP_Departments
     */
    public function addToDepartment(\StructType\JP_CustomerIDElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CustomerIDElement) {
            throw new \InvalidArgumentException(sprintf('The Department property can only contain items of type \StructType\JP_CustomerIDElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Department[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Departments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
