<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseBooking StructType
 * @subpackage Structs
 */
class JP_CruiseBooking extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The Paxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The Holder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Holder
     */
    public $Holder;
    /**
     * The ReservationLocator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationLocator;
    /**
     * The ExternalBookingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * The FileNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileNumber;
    /**
     * The Agent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Agent
     */
    public $Agent;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The Elements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseElements
     */
    public $Elements;
    /**
     * The AdvancedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseBookingAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_CruiseBooking
     * @uses JP_CruiseBooking::setLogin()
     * @uses JP_CruiseBooking::setPaxes()
     * @uses JP_CruiseBooking::setHolder()
     * @uses JP_CruiseBooking::setReservationLocator()
     * @uses JP_CruiseBooking::setExternalBookingReference()
     * @uses JP_CruiseBooking::setFileNumber()
     * @uses JP_CruiseBooking::setAgent()
     * @uses JP_CruiseBooking::setComments()
     * @uses JP_CruiseBooking::setElements()
     * @uses JP_CruiseBooking::setAdvancedOptions()
     * @uses JP_CruiseBooking::setRestrictedOptions()
     * @uses JP_CruiseBooking::setVersion()
     * @uses JP_CruiseBooking::setLanguage()
     * @uses JP_CruiseBooking::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_Paxes $paxes
     * @param \StructType\JP_Holder $holder
     * @param string $reservationLocator
     * @param string $externalBookingReference
     * @param string $fileNumber
     * @param \StructType\JP_Agent $agent
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param \StructType\JP_CruiseElements $elements
     * @param \StructType\JP_CruiseBookingAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_Paxes $paxes = null, \StructType\JP_Holder $holder = null, $reservationLocator = null, $externalBookingReference = null, $fileNumber = null, \StructType\JP_Agent $agent = null, \ArrayType\ArrayOfJP_Comment $comments = null, \StructType\JP_CruiseElements $elements = null, \StructType\JP_CruiseBookingAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setPaxes($paxes)
            ->setHolder($holder)
            ->setReservationLocator($reservationLocator)
            ->setExternalBookingReference($externalBookingReference)
            ->setFileNumber($fileNumber)
            ->setAgent($agent)
            ->setComments($comments)
            ->setElements($elements)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_CruiseBooking
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_CruiseBooking
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get Holder value
     * @return \StructType\JP_Holder|null
     */
    public function getHolder()
    {
        return $this->Holder;
    }
    /**
     * Set Holder value
     * @param \StructType\JP_Holder $holder
     * @return \StructType\JP_CruiseBooking
     */
    public function setHolder(\StructType\JP_Holder $holder = null)
    {
        $this->Holder = $holder;
        return $this;
    }
    /**
     * Get ReservationLocator value
     * @return string|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param string $reservationLocator
     * @return \StructType\JP_CruiseBooking
     */
    public function setReservationLocator($reservationLocator = null)
    {
        // validation for constraint: string
        if (!is_null($reservationLocator) && !is_string($reservationLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationLocator, true), gettype($reservationLocator)), __LINE__);
        }
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\JP_CruiseBooking
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingReference, true), gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
    /**
     * Get FileNumber value
     * @return string|null
     */
    public function getFileNumber()
    {
        return $this->FileNumber;
    }
    /**
     * Set FileNumber value
     * @param string $fileNumber
     * @return \StructType\JP_CruiseBooking
     */
    public function setFileNumber($fileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fileNumber) && !is_string($fileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileNumber, true), gettype($fileNumber)), __LINE__);
        }
        $this->FileNumber = $fileNumber;
        return $this;
    }
    /**
     * Get Agent value
     * @return \StructType\JP_Agent|null
     */
    public function getAgent()
    {
        return $this->Agent;
    }
    /**
     * Set Agent value
     * @param \StructType\JP_Agent $agent
     * @return \StructType\JP_CruiseBooking
     */
    public function setAgent(\StructType\JP_Agent $agent = null)
    {
        $this->Agent = $agent;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_CruiseBooking
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Elements value
     * @return \StructType\JP_CruiseElements|null
     */
    public function getElements()
    {
        return $this->Elements;
    }
    /**
     * Set Elements value
     * @param \StructType\JP_CruiseElements $elements
     * @return \StructType\JP_CruiseBooking
     */
    public function setElements(\StructType\JP_CruiseElements $elements = null)
    {
        $this->Elements = $elements;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_CruiseBookingAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_CruiseBookingAdvancedOptions $advancedOptions
     * @return \StructType\JP_CruiseBooking
     */
    public function setAdvancedOptions(\StructType\JP_CruiseBookingAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_CruiseBooking
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_CruiseBooking
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_CruiseBooking
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_CruiseBooking
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseBooking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
