<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insurance ServiceType
 * @subpackage Services
 */
class Insurance extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsuranceBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for hotels.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsuranceBooking $parameters
     * @return \StructType\InsuranceBookingResponse|bool
     */
    public function InsuranceBooking(\StructType\InsuranceBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsuranceBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsuranceAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for insurances.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsuranceAvail $parameters
     * @return \StructType\InsuranceAvailResponse|bool
     */
    public function InsuranceAvail(\StructType\InsuranceAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsuranceAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsuranceCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for insurances.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsuranceCheckAvail $parameters
     * @return \StructType\InsuranceCheckAvailResponse|bool
     */
    public function InsuranceCheckAvail(\StructType\InsuranceCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsuranceCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsuranceBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules Of Insurances
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsuranceBookingRules $parameters
     * @return \StructType\InsuranceBookingRulesResponse|bool
     */
    public function InsuranceBookingRules(\StructType\InsuranceBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsuranceBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InsuranceAvailResponse|\StructType\InsuranceBookingResponse|\StructType\InsuranceBookingRulesResponse|\StructType\InsuranceCheckAvailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
