<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Zone ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Zone extends AbstractStructArrayBase
{
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Zone[]
     */
    public $Zone;
    /**
     * Constructor method for ArrayOfJP_Zone
     * @uses ArrayOfJP_Zone::setZone()
     * @param \StructType\JP_Zone[] $zone
     */
    public function __construct(array $zone = array())
    {
        $this
            ->setZone($zone);
    }
    /**
     * Get Zone value
     * @return \StructType\JP_Zone[]|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * This method is responsible for validating the values passed to the setZone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZoneForArrayConstraintsFromSetZone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ZoneZoneItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ZoneZoneItem instanceof \StructType\JP_Zone) {
                $invalidValues[] = is_object($arrayOfJP_ZoneZoneItem) ? get_class($arrayOfJP_ZoneZoneItem) : sprintf('%s(%s)', gettype($arrayOfJP_ZoneZoneItem), var_export($arrayOfJP_ZoneZoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Zone property can only contain items of type \StructType\JP_Zone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Zone value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Zone[] $zone
     * @return \ArrayType\ArrayOfJP_Zone
     */
    public function setZone(array $zone = array())
    {
        // validation for constraint: array
        if ('' !== ($zoneArrayErrorMessage = self::validateZoneForArrayConstraintsFromSetZone($zone))) {
            throw new \InvalidArgumentException($zoneArrayErrorMessage, __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Add item to Zone value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Zone $item
     * @return \ArrayType\ArrayOfJP_Zone
     */
    public function addToZone(\StructType\JP_Zone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Zone) {
            throw new \InvalidArgumentException(sprintf('The Zone property can only contain items of type \StructType\JP_Zone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Zone[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Zone|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Zone|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Zone|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Zone|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Zone|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Zone
     */
    public function getAttributeName()
    {
        return 'Zone';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Zone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
