<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RelPax StructType
 * @subpackage Structs
 */
class JP_RelPax extends AbstractStructBase
{
    /**
     * The IdPax
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $IdPax;
    /**
     * The PaxSeats
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PaxSeat
     */
    public $PaxSeats;
    /**
     * Constructor method for JP_RelPax
     * @uses JP_RelPax::setIdPax()
     * @uses JP_RelPax::setPaxSeats()
     * @param int $idPax
     * @param \ArrayType\ArrayOfJP_PaxSeat $paxSeats
     */
    public function __construct($idPax = null, \ArrayType\ArrayOfJP_PaxSeat $paxSeats = null)
    {
        $this
            ->setIdPax($idPax)
            ->setPaxSeats($paxSeats);
    }
    /**
     * Get IdPax value
     * @return int
     */
    public function getIdPax()
    {
        return $this->IdPax;
    }
    /**
     * Set IdPax value
     * @param int $idPax
     * @return \StructType\JP_RelPax
     */
    public function setIdPax($idPax = null)
    {
        // validation for constraint: int
        if (!is_null($idPax) && !(is_int($idPax) || ctype_digit($idPax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPax, true), gettype($idPax)), __LINE__);
        }
        $this->IdPax = $idPax;
        return $this;
    }
    /**
     * Get PaxSeats value
     * @return \ArrayType\ArrayOfJP_PaxSeat|null
     */
    public function getPaxSeats()
    {
        return $this->PaxSeats;
    }
    /**
     * Set PaxSeats value
     * @param \ArrayType\ArrayOfJP_PaxSeat $paxSeats
     * @return \StructType\JP_RelPax
     */
    public function setPaxSeats(\ArrayType\ArrayOfJP_PaxSeat $paxSeats = null)
    {
        $this->PaxSeats = $paxSeats;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RelPax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
