<?php

namespace EnumType;

/**
 * This class stands for JP_CommentType EnumType
 * @subpackage Enumerations
 */
class JP_CommentType
{
    /**
     * Constant for value 'HOT'
     * @return string 'HOT'
     */
    const VALUE_HOT = 'HOT';
    /**
     * Constant for value 'SUP'
     * @return string 'SUP'
     */
    const VALUE_SUP = 'SUP';
    /**
     * Constant for value 'CHKAV'
     * @return string 'CHKAV'
     */
    const VALUE_CHKAV = 'CHKAV';
    /**
     * Constant for value 'RES'
     * @return string 'RES'
     */
    const VALUE_RES = 'RES';
    /**
     * Constant for value 'INT'
     * @return string 'INT'
     */
    const VALUE_INT = 'INT';
    /**
     * Constant for value 'ESP'
     * @return string 'ESP'
     */
    const VALUE_ESP = 'ESP';
    /**
     * Constant for value 'ELE'
     * @return string 'ELE'
     */
    const VALUE_ELE = 'ELE';
    /**
     * Constant for value 'TRF'
     * @return string 'TRF'
     */
    const VALUE_TRF = 'TRF';
    /**
     * Constant for value 'TKT'
     * @return string 'TKT'
     */
    const VALUE_TKT = 'TKT';
    /**
     * Constant for value 'PAG'
     * @return string 'PAG'
     */
    const VALUE_PAG = 'PAG';
    /**
     * Constant for value 'OTHER'
     * @return string 'OTHER'
     */
    const VALUE_OTHER = 'OTHER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOT
     * @uses self::VALUE_SUP
     * @uses self::VALUE_CHKAV
     * @uses self::VALUE_RES
     * @uses self::VALUE_INT
     * @uses self::VALUE_ESP
     * @uses self::VALUE_ELE
     * @uses self::VALUE_TRF
     * @uses self::VALUE_TKT
     * @uses self::VALUE_PAG
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOT,
            self::VALUE_SUP,
            self::VALUE_CHKAV,
            self::VALUE_RES,
            self::VALUE_INT,
            self::VALUE_ESP,
            self::VALUE_ELE,
            self::VALUE_TRF,
            self::VALUE_TKT,
            self::VALUE_PAG,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
