<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_ContractRestrictionApplication EnumType
 * @subpackage Enumerations
 */
class JPSOAP_ContractRestrictionApplication
{
    /**
     * Constant for value 'OnlyAccommodationWithPossiblePackage'
     * @return string 'OnlyAccommodationWithPossiblePackage'
     */
    const VALUE_ONLY_ACCOMMODATION_WITH_POSSIBLE_PACKAGE = 'OnlyAccommodationWithPossiblePackage';
    /**
     * Constant for value 'OnlyAccommodation'
     * @return string 'OnlyAccommodation'
     */
    const VALUE_ONLY_ACCOMMODATION = 'OnlyAccommodation';
    /**
     * Constant for value 'OnlyDynamicPackage'
     * @return string 'OnlyDynamicPackage'
     */
    const VALUE_ONLY_DYNAMIC_PACKAGE = 'OnlyDynamicPackage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONLY_ACCOMMODATION_WITH_POSSIBLE_PACKAGE
     * @uses self::VALUE_ONLY_ACCOMMODATION
     * @uses self::VALUE_ONLY_DYNAMIC_PACKAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLY_ACCOMMODATION_WITH_POSSIBLE_PACKAGE,
            self::VALUE_ONLY_ACCOMMODATION,
            self::VALUE_ONLY_DYNAMIC_PACKAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
