<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceModify StructType
 * @subpackage Structs
 */
class JP_ServiceModify extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The ReservationLocator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ReservationLocationModify
     */
    public $ReservationLocator;
    /**
     * The Paxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The Holder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Holder
     */
    public $Holder;
    /**
     * The ExternalBookingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The SearchSegmentServices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_SearchSegmentServicesModify
     */
    public $SearchSegmentServices;
    /**
     * The RelPaxesDist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPaxDist
     */
    public $RelPaxesDist;
    /**
     * The ServiceBookingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceBookingInfo
     */
    public $ServiceBookingInfo;
    /**
     * The AdvancedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServicesModifyAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_ServiceModify
     * @uses JP_ServiceModify::setLogin()
     * @uses JP_ServiceModify::setReservationLocator()
     * @uses JP_ServiceModify::setPaxes()
     * @uses JP_ServiceModify::setHolder()
     * @uses JP_ServiceModify::setExternalBookingReference()
     * @uses JP_ServiceModify::setComments()
     * @uses JP_ServiceModify::setSearchSegmentServices()
     * @uses JP_ServiceModify::setRelPaxesDist()
     * @uses JP_ServiceModify::setServiceBookingInfo()
     * @uses JP_ServiceModify::setAdvancedOptions()
     * @uses JP_ServiceModify::setRestrictedOptions()
     * @uses JP_ServiceModify::setVersion()
     * @uses JP_ServiceModify::setLanguage()
     * @uses JP_ServiceModify::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_ReservationLocationModify $reservationLocator
     * @param \StructType\JP_Paxes $paxes
     * @param \StructType\JP_Holder $holder
     * @param string $externalBookingReference
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param \StructType\JP_SearchSegmentServicesModify $searchSegmentServices
     * @param \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist
     * @param \StructType\JP_ServiceBookingInfo $serviceBookingInfo
     * @param \StructType\JP_ServicesModifyAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_ReservationLocationModify $reservationLocator = null, \StructType\JP_Paxes $paxes = null, \StructType\JP_Holder $holder = null, $externalBookingReference = null, \ArrayType\ArrayOfJP_Comment $comments = null, \StructType\JP_SearchSegmentServicesModify $searchSegmentServices = null, \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist = null, \StructType\JP_ServiceBookingInfo $serviceBookingInfo = null, \StructType\JP_ServicesModifyAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setReservationLocator($reservationLocator)
            ->setPaxes($paxes)
            ->setHolder($holder)
            ->setExternalBookingReference($externalBookingReference)
            ->setComments($comments)
            ->setSearchSegmentServices($searchSegmentServices)
            ->setRelPaxesDist($relPaxesDist)
            ->setServiceBookingInfo($serviceBookingInfo)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_ServiceModify
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get ReservationLocator value
     * @return \StructType\JP_ReservationLocationModify|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param \StructType\JP_ReservationLocationModify $reservationLocator
     * @return \StructType\JP_ServiceModify
     */
    public function setReservationLocator(\StructType\JP_ReservationLocationModify $reservationLocator = null)
    {
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_ServiceModify
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get Holder value
     * @return \StructType\JP_Holder|null
     */
    public function getHolder()
    {
        return $this->Holder;
    }
    /**
     * Set Holder value
     * @param \StructType\JP_Holder $holder
     * @return \StructType\JP_ServiceModify
     */
    public function setHolder(\StructType\JP_Holder $holder = null)
    {
        $this->Holder = $holder;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\JP_ServiceModify
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingReference, true), gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_ServiceModify
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SearchSegmentServices value
     * @return \StructType\JP_SearchSegmentServicesModify|null
     */
    public function getSearchSegmentServices()
    {
        return $this->SearchSegmentServices;
    }
    /**
     * Set SearchSegmentServices value
     * @param \StructType\JP_SearchSegmentServicesModify $searchSegmentServices
     * @return \StructType\JP_ServiceModify
     */
    public function setSearchSegmentServices(\StructType\JP_SearchSegmentServicesModify $searchSegmentServices = null)
    {
        $this->SearchSegmentServices = $searchSegmentServices;
        return $this;
    }
    /**
     * Get RelPaxesDist value
     * @return \ArrayType\ArrayOfJP_RelPaxDist|null
     */
    public function getRelPaxesDist()
    {
        return $this->RelPaxesDist;
    }
    /**
     * Set RelPaxesDist value
     * @param \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist
     * @return \StructType\JP_ServiceModify
     */
    public function setRelPaxesDist(\ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist = null)
    {
        $this->RelPaxesDist = $relPaxesDist;
        return $this;
    }
    /**
     * Get ServiceBookingInfo value
     * @return \StructType\JP_ServiceBookingInfo|null
     */
    public function getServiceBookingInfo()
    {
        return $this->ServiceBookingInfo;
    }
    /**
     * Set ServiceBookingInfo value
     * @param \StructType\JP_ServiceBookingInfo $serviceBookingInfo
     * @return \StructType\JP_ServiceModify
     */
    public function setServiceBookingInfo(\StructType\JP_ServiceBookingInfo $serviceBookingInfo = null)
    {
        $this->ServiceBookingInfo = $serviceBookingInfo;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_ServicesModifyAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_ServicesModifyAdvancedOptions $advancedOptions
     * @return \StructType\JP_ServiceModify
     */
    public function setAdvancedOptions(\StructType\JP_ServicesModifyAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_ServiceModify
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_ServiceModify
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_ServiceModify
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_ServiceModify
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceModify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
