<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentServicesModify StructType
 * @subpackage Structs
 */
class JP_SearchSegmentServicesModify extends AbstractStructBase
{
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The InternalSupplier
     * @var int
     */
    public $InternalSupplier;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The OptionCode
     * @var string
     */
    public $OptionCode;
    /**
     * Constructor method for JP_SearchSegmentServicesModify
     * @uses JP_SearchSegmentServicesModify::setStart()
     * @uses JP_SearchSegmentServicesModify::setEnd()
     * @uses JP_SearchSegmentServicesModify::setInternalSupplier()
     * @uses JP_SearchSegmentServicesModify::setCode()
     * @uses JP_SearchSegmentServicesModify::setOptionCode()
     * @param string $start
     * @param string $end
     * @param int $internalSupplier
     * @param string $code
     * @param string $optionCode
     */
    public function __construct($start = null, $end = null, $internalSupplier = null, $code = null, $optionCode = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setInternalSupplier($internalSupplier)
            ->setCode($code)
            ->setOptionCode($optionCode);
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_SearchSegmentServicesModify
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_SearchSegmentServicesModify
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get InternalSupplier value
     * @return int|null
     */
    public function getInternalSupplier()
    {
        return $this->InternalSupplier;
    }
    /**
     * Set InternalSupplier value
     * @param int $internalSupplier
     * @return \StructType\JP_SearchSegmentServicesModify
     */
    public function setInternalSupplier($internalSupplier = null)
    {
        // validation for constraint: int
        if (!is_null($internalSupplier) && !(is_int($internalSupplier) || ctype_digit($internalSupplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalSupplier, true), gettype($internalSupplier)), __LINE__);
        }
        $this->InternalSupplier = $internalSupplier;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_SearchSegmentServicesModify
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OptionCode value
     * @return string|null
     */
    public function getOptionCode()
    {
        return $this->OptionCode;
    }
    /**
     * Set OptionCode value
     * @param string $optionCode
     * @return \StructType\JP_SearchSegmentServicesModify
     */
    public function setOptionCode($optionCode = null)
    {
        // validation for constraint: string
        if (!is_null($optionCode) && !is_string($optionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionCode, true), gettype($optionCode)), __LINE__);
        }
        $this->OptionCode = $optionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SearchSegmentServicesModify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
