<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RelatedServiceInfo StructType
 * @subpackage Structs
 */
class JP_RelatedServiceInfo extends AbstractStructBase
{
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceType;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Code;
    /**
     * The OptionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OptionCode;
    /**
     * The MeetingPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_MeetingPointList
     */
    public $MeetingPoint;
    /**
     * The Origins
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * Constructor method for JP_RelatedServiceInfo
     * @uses JP_RelatedServiceInfo::setServiceType()
     * @uses JP_RelatedServiceInfo::setCode()
     * @uses JP_RelatedServiceInfo::setOptionCode()
     * @uses JP_RelatedServiceInfo::setMeetingPoint()
     * @uses JP_RelatedServiceInfo::setOrigins()
     * @uses JP_RelatedServiceInfo::setDestinations()
     * @param int $serviceType
     * @param int $code
     * @param int $optionCode
     * @param \StructType\JP_MeetingPointList $meetingPoint
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     */
    public function __construct($serviceType = null, $code = null, $optionCode = null, \StructType\JP_MeetingPointList $meetingPoint = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setCode($code)
            ->setOptionCode($optionCode)
            ->setMeetingPoint($meetingPoint)
            ->setOrigins($origins)
            ->setDestinations($destinations);
    }
    /**
     * Get ServiceType value
     * @return int
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param int $serviceType
     * @return \StructType\JP_RelatedServiceInfo
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: int
        if (!is_null($serviceType) && !(is_int($serviceType) || ctype_digit($serviceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_RelatedServiceInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OptionCode value
     * @return int
     */
    public function getOptionCode()
    {
        return $this->OptionCode;
    }
    /**
     * Set OptionCode value
     * @param int $optionCode
     * @return \StructType\JP_RelatedServiceInfo
     */
    public function setOptionCode($optionCode = null)
    {
        // validation for constraint: int
        if (!is_null($optionCode) && !(is_int($optionCode) || ctype_digit($optionCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionCode, true), gettype($optionCode)), __LINE__);
        }
        $this->OptionCode = $optionCode;
        return $this;
    }
    /**
     * Get MeetingPoint value
     * @return \StructType\JP_MeetingPointList|null
     */
    public function getMeetingPoint()
    {
        return $this->MeetingPoint;
    }
    /**
     * Set MeetingPoint value
     * @param \StructType\JP_MeetingPointList $meetingPoint
     * @return \StructType\JP_RelatedServiceInfo
     */
    public function setMeetingPoint(\StructType\JP_MeetingPointList $meetingPoint = null)
    {
        $this->MeetingPoint = $meetingPoint;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_RelatedServiceInfo
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_RelatedServiceInfo
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RelatedServiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
